package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodTemplateSpecPreviewBuilder extends PodTemplateSpecPreviewFluent<PodTemplateSpecPreviewBuilder> implements VisitableBuilder<PodTemplateSpecPreview,PodTemplateSpecPreviewBuilder>{
  public PodTemplateSpecPreviewBuilder() {
    this(false);
  }
  public PodTemplateSpecPreviewBuilder(Boolean validationEnabled) {
    this(new PodTemplateSpecPreview(), validationEnabled);
  }
  public PodTemplateSpecPreviewBuilder(PodTemplateSpecPreviewFluent<?> fluent) {
    this(fluent, false);
  }
  public PodTemplateSpecPreviewBuilder(PodTemplateSpecPreviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodTemplateSpecPreview(), validationEnabled);
  }
  public PodTemplateSpecPreviewBuilder(PodTemplateSpecPreviewFluent<?> fluent,PodTemplateSpecPreview instance) {
    this(fluent, instance, false);
  }
  public PodTemplateSpecPreviewBuilder(PodTemplateSpecPreviewFluent<?> fluent,PodTemplateSpecPreview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodTemplateSpecPreview());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodTemplateSpecPreviewBuilder(PodTemplateSpecPreview instance) {
    this(instance,false);
  }
  public PodTemplateSpecPreviewBuilder(PodTemplateSpecPreview instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodTemplateSpecPreview());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodTemplateSpecPreviewFluent<?> fluent;
  Boolean validationEnabled;
  public PodTemplateSpecPreview build() {
    PodTemplateSpecPreview buildable = new PodTemplateSpecPreview();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setSpec(fluent.buildSpec());
    return buildable;
  }
  
}