package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetadataBuilder extends MetadataFluent<MetadataBuilder> implements VisitableBuilder<Metadata,MetadataBuilder>{
  public MetadataBuilder() {
    this(false);
  }
  public MetadataBuilder(Boolean validationEnabled) {
    this(new Metadata(), validationEnabled);
  }
  public MetadataBuilder(MetadataFluent<?> fluent) {
    this(fluent, false);
  }
  public MetadataBuilder(MetadataFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Metadata(), validationEnabled);
  }
  public MetadataBuilder(MetadataFluent<?> fluent,Metadata instance) {
    this(fluent, instance, false);
  }
  public MetadataBuilder(MetadataFluent<?> fluent,Metadata instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Metadata());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withClusterName(instance.getClusterName());
      fluent.withCreationTimestamp(instance.getCreationTimestamp());
      fluent.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
      fluent.withDeletionTimestamp(instance.getDeletionTimestamp());
      fluent.withFinalizers(instance.getFinalizers());
      fluent.withGenerateName(instance.getGenerateName());
      fluent.withGeneration(instance.getGeneration());
      fluent.withLabels(instance.getLabels());
      fluent.withManagedFields(instance.getManagedFields());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withOwnerReferences(instance.getOwnerReferences());
      fluent.withResourceVersion(instance.getResourceVersion());
      fluent.withSelfLink(instance.getSelfLink());
      fluent.withUid(instance.getUid());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MetadataBuilder(Metadata instance) {
    this(instance,false);
  }
  public MetadataBuilder(Metadata instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Metadata());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withClusterName(instance.getClusterName());
      this.withCreationTimestamp(instance.getCreationTimestamp());
      this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
      this.withDeletionTimestamp(instance.getDeletionTimestamp());
      this.withFinalizers(instance.getFinalizers());
      this.withGenerateName(instance.getGenerateName());
      this.withGeneration(instance.getGeneration());
      this.withLabels(instance.getLabels());
      this.withManagedFields(instance.getManagedFields());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withOwnerReferences(instance.getOwnerReferences());
      this.withResourceVersion(instance.getResourceVersion());
      this.withSelfLink(instance.getSelfLink());
      this.withUid(instance.getUid());
    }
    this.validationEnabled = validationEnabled; 
  }
  MetadataFluent<?> fluent;
  Boolean validationEnabled;
  public Metadata build() {
    Metadata buildable = new Metadata();
    buildable.setAnnotations(fluent.getAnnotations());
    buildable.setClusterName(fluent.getClusterName());
    buildable.setCreationTimestamp(fluent.getCreationTimestamp());
    buildable.setDeletionGracePeriodSeconds(fluent.getDeletionGracePeriodSeconds());
    buildable.setDeletionTimestamp(fluent.getDeletionTimestamp());
    buildable.setFinalizers(fluent.getFinalizers());
    buildable.setGenerateName(fluent.getGenerateName());
    buildable.setGeneration(fluent.getGeneration());
    buildable.setLabels(fluent.getLabels());
    buildable.setManagedFields(fluent.buildManagedFields());
    buildable.setName(fluent.getName());
    buildable.setNamespace(fluent.getNamespace());
    buildable.setOwnerReferences(fluent.buildOwnerReferences());
    buildable.setResourceVersion(fluent.getResourceVersion());
    buildable.setSelfLink(fluent.getSelfLink());
    buildable.setUid(fluent.getUid());
    return buildable;
  }
  
}