package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.metadata;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedFieldsBuilder extends ManagedFieldsFluent<ManagedFieldsBuilder> implements VisitableBuilder<ManagedFields,ManagedFieldsBuilder>{
  public ManagedFieldsBuilder() {
    this(false);
  }
  public ManagedFieldsBuilder(Boolean validationEnabled) {
    this(new ManagedFields(), validationEnabled);
  }
  public ManagedFieldsBuilder(ManagedFieldsFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedFieldsBuilder(ManagedFieldsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedFields(), validationEnabled);
  }
  public ManagedFieldsBuilder(ManagedFieldsFluent<?> fluent,ManagedFields instance) {
    this(fluent, instance, false);
  }
  public ManagedFieldsBuilder(ManagedFieldsFluent<?> fluent,ManagedFields instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ManagedFields());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withFieldsType(instance.getFieldsType());
      fluent.withFieldsV1(instance.getFieldsV1());
      fluent.withManager(instance.getManager());
      fluent.withOperation(instance.getOperation());
      fluent.withSubresource(instance.getSubresource());
      fluent.withTime(instance.getTime());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ManagedFieldsBuilder(ManagedFields instance) {
    this(instance,false);
  }
  public ManagedFieldsBuilder(ManagedFields instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ManagedFields());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withFieldsType(instance.getFieldsType());
      this.withFieldsV1(instance.getFieldsV1());
      this.withManager(instance.getManager());
      this.withOperation(instance.getOperation());
      this.withSubresource(instance.getSubresource());
      this.withTime(instance.getTime());
    }
    this.validationEnabled = validationEnabled; 
  }
  ManagedFieldsFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedFields build() {
    ManagedFields buildable = new ManagedFields();
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setFieldsType(fluent.getFieldsType());
    buildable.setFieldsV1(fluent.buildFieldsV1());
    buildable.setManager(fluent.getManager());
    buildable.setOperation(fluent.getOperation());
    buildable.setSubresource(fluent.getSubresource());
    buildable.setTime(fluent.getTime());
    return buildable;
  }
  
}