package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.metadata;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OwnerReferencesBuilder extends OwnerReferencesFluent<OwnerReferencesBuilder> implements VisitableBuilder<OwnerReferences,OwnerReferencesBuilder>{
  public OwnerReferencesBuilder() {
    this(false);
  }
  public OwnerReferencesBuilder(Boolean validationEnabled) {
    this(new OwnerReferences(), validationEnabled);
  }
  public OwnerReferencesBuilder(OwnerReferencesFluent<?> fluent) {
    this(fluent, false);
  }
  public OwnerReferencesBuilder(OwnerReferencesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OwnerReferences(), validationEnabled);
  }
  public OwnerReferencesBuilder(OwnerReferencesFluent<?> fluent,OwnerReferences instance) {
    this(fluent, instance, false);
  }
  public OwnerReferencesBuilder(OwnerReferencesFluent<?> fluent,OwnerReferences instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OwnerReferences());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withBlockOwnerDeletion(instance.getBlockOwnerDeletion());
      fluent.withController(instance.getController());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withUid(instance.getUid());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OwnerReferencesBuilder(OwnerReferences instance) {
    this(instance,false);
  }
  public OwnerReferencesBuilder(OwnerReferences instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OwnerReferences());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withBlockOwnerDeletion(instance.getBlockOwnerDeletion());
      this.withController(instance.getController());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withUid(instance.getUid());
    }
    this.validationEnabled = validationEnabled; 
  }
  OwnerReferencesFluent<?> fluent;
  Boolean validationEnabled;
  public OwnerReferences build() {
    OwnerReferences buildable = new OwnerReferences();
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setBlockOwnerDeletion(fluent.getBlockOwnerDeletion());
    buildable.setController(fluent.getController());
    buildable.setKind(fluent.getKind());
    buildable.setName(fluent.getName());
    buildable.setUid(fluent.getUid());
    return buildable;
  }
  
}