package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DnsConfigBuilder extends DnsConfigFluent<DnsConfigBuilder> implements VisitableBuilder<DnsConfig,DnsConfigBuilder>{
  public DnsConfigBuilder() {
    this(false);
  }
  public DnsConfigBuilder(Boolean validationEnabled) {
    this(new DnsConfig(), validationEnabled);
  }
  public DnsConfigBuilder(DnsConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public DnsConfigBuilder(DnsConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DnsConfig(), validationEnabled);
  }
  public DnsConfigBuilder(DnsConfigFluent<?> fluent,DnsConfig instance) {
    this(fluent, instance, false);
  }
  public DnsConfigBuilder(DnsConfigFluent<?> fluent,DnsConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DnsConfig());

    if (instance != null) {
      fluent.withNameservers(instance.getNameservers());
      fluent.withOptions(instance.getOptions());
      fluent.withSearches(instance.getSearches());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DnsConfigBuilder(DnsConfig instance) {
    this(instance,false);
  }
  public DnsConfigBuilder(DnsConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DnsConfig());

    if (instance != null) {
      this.withNameservers(instance.getNameservers());
      this.withOptions(instance.getOptions());
      this.withSearches(instance.getSearches());
    }
    this.validationEnabled = validationEnabled; 
  }
  DnsConfigFluent<?> fluent;
  Boolean validationEnabled;
  public DnsConfig build() {
    DnsConfig buildable = new DnsConfig();
    buildable.setNameservers(fluent.getNameservers());
    buildable.setOptions(fluent.buildOptions());
    buildable.setSearches(fluent.getSearches());
    return buildable;
  }
  
}