package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec;

import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.dnsconfig.Options;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.dnsconfig.OptionsFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.dnsconfig.OptionsBuilder;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DnsConfigFluent<A extends DnsConfigFluent<A>> extends BaseFluent<A>{
  public DnsConfigFluent() {
  }
  public DnsConfigFluent(DnsConfig instance) {
    instance = (instance != null ? instance : new DnsConfig());

    if (instance != null) {
      this.withNameservers(instance.getNameservers());
      this.withOptions(instance.getOptions());
      this.withSearches(instance.getSearches());
    }
  }
  private List<String> nameservers;
  private ArrayList<OptionsBuilder> options;
  private List<String> searches;
  public A addToNameservers(int index,String item) {
    if (this.nameservers == null) {this.nameservers = new ArrayList<String>();}
    this.nameservers.add(index, item);
    return (A)this;
  }
  public A setToNameservers(int index,String item) {
    if (this.nameservers == null) {this.nameservers = new ArrayList<String>();}
    this.nameservers.set(index, item); return (A)this;
  }
  public A addToNameservers(java.lang.String... items) {
    if (this.nameservers == null) {this.nameservers = new ArrayList<String>();}
    for (String item : items) {this.nameservers.add(item);} return (A)this;
  }
  public A addAllToNameservers(Collection<String> items) {
    if (this.nameservers == null) {this.nameservers = new ArrayList<String>();}
    for (String item : items) {this.nameservers.add(item);} return (A)this;
  }
  public A removeFromNameservers(java.lang.String... items) {
    if (this.nameservers == null) return (A)this;
    for (String item : items) { this.nameservers.remove(item);} return (A)this;
  }
  public A removeAllFromNameservers(Collection<String> items) {
    if (this.nameservers == null) return (A)this;
    for (String item : items) { this.nameservers.remove(item);} return (A)this;
  }
  public List<String> getNameservers() {
    return this.nameservers;
  }
  public String getNameserver(int index) {
    return this.nameservers.get(index);
  }
  public String getFirstNameserver() {
    return this.nameservers.get(0);
  }
  public String getLastNameserver() {
    return this.nameservers.get(nameservers.size() - 1);
  }
  public String getMatchingNameserver(Predicate<String> predicate) {
    for (String item: nameservers) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingNameserver(Predicate<String> predicate) {
    for (String item: nameservers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNameservers(List<String> nameservers) {
    if (nameservers != null) {this.nameservers = new ArrayList(); for (String item : nameservers){this.addToNameservers(item);}} else { this.nameservers = null;} return (A) this;
  }
  public A withNameservers(java.lang.String... nameservers) {
    if (this.nameservers != null) {this.nameservers.clear(); _visitables.remove("nameservers"); }
    if (nameservers != null) {for (String item :nameservers){ this.addToNameservers(item);}} return (A) this;
  }
  public boolean hasNameservers() {
    return nameservers != null && !nameservers.isEmpty();
  }
  public A addToOptions(int index,Options item) {
    if (this.options == null) {this.options = new ArrayList<OptionsBuilder>();}
    OptionsBuilder builder = new OptionsBuilder(item);
    if (index < 0 || index >= options.size()) { _visitables.get("options").add(builder); options.add(builder); } else { _visitables.get("options").add(index, builder); options.add(index, builder);}
    return (A)this;
  }
  public A setToOptions(int index,Options item) {
    if (this.options == null) {this.options = new ArrayList<OptionsBuilder>();}
    OptionsBuilder builder = new OptionsBuilder(item);
    if (index < 0 || index >= options.size()) { _visitables.get("options").add(builder); options.add(builder); } else { _visitables.get("options").set(index, builder); options.set(index, builder);}
    return (A)this;
  }
  public A addToOptions(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.dnsconfig.Options... items) {
    if (this.options == null) {this.options = new ArrayList<OptionsBuilder>();}
    for (Options item : items) {OptionsBuilder builder = new OptionsBuilder(item);_visitables.get("options").add(builder);this.options.add(builder);} return (A)this;
  }
  public A addAllToOptions(Collection<Options> items) {
    if (this.options == null) {this.options = new ArrayList<OptionsBuilder>();}
    for (Options item : items) {OptionsBuilder builder = new OptionsBuilder(item);_visitables.get("options").add(builder);this.options.add(builder);} return (A)this;
  }
  public A removeFromOptions(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.dnsconfig.Options... items) {
    if (this.options == null) return (A)this;
    for (Options item : items) {OptionsBuilder builder = new OptionsBuilder(item);_visitables.get("options").remove(builder); this.options.remove(builder);} return (A)this;
  }
  public A removeAllFromOptions(Collection<Options> items) {
    if (this.options == null) return (A)this;
    for (Options item : items) {OptionsBuilder builder = new OptionsBuilder(item);_visitables.get("options").remove(builder); this.options.remove(builder);} return (A)this;
  }
  public A removeMatchingFromOptions(Predicate<OptionsBuilder> predicate) {
    if (options == null) return (A) this;
    final Iterator<OptionsBuilder> each = options.iterator();
    final List visitables = _visitables.get("options");
    while (each.hasNext()) {
      OptionsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Options> buildOptions() {
    return options != null ? build(options) : null;
  }
  public Options buildOption(int index) {
    return this.options.get(index).build();
  }
  public Options buildFirstOption() {
    return this.options.get(0).build();
  }
  public Options buildLastOption() {
    return this.options.get(options.size() - 1).build();
  }
  public Options buildMatchingOption(Predicate<OptionsBuilder> predicate) {
    for (OptionsBuilder item: options) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingOption(Predicate<OptionsBuilder> predicate) {
    for (OptionsBuilder item: options) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOptions(List<Options> options) {
    if (this.options != null) { _visitables.get("options").clear();}
    if (options != null) {this.options = new ArrayList(); for (Options item : options){this.addToOptions(item);}} else { this.options = null;} return (A) this;
  }
  public A withOptions(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.dnsconfig.Options... options) {
    if (this.options != null) {this.options.clear(); _visitables.remove("options"); }
    if (options != null) {for (Options item :options){ this.addToOptions(item);}} return (A) this;
  }
  public boolean hasOptions() {
    return options != null && !options.isEmpty();
  }
  public OptionsNested<A> addNewOption() {
    return new OptionsNested(-1, null);
  }
  public OptionsNested<A> addNewOptionLike(Options item) {
    return new OptionsNested(-1, item);
  }
  public OptionsNested<A> setNewOptionLike(int index,Options item) {
    return new OptionsNested(index, item);
  }
  public OptionsNested<A> editOption(int index) {
    if (options.size() <= index) throw new RuntimeException("Can't edit options. Index exceeds size.");
    return setNewOptionLike(index, buildOption(index));
  }
  public OptionsNested<A> editFirstOption() {
    if (options.size() == 0) throw new RuntimeException("Can't edit first options. The list is empty.");
    return setNewOptionLike(0, buildOption(0));
  }
  public OptionsNested<A> editLastOption() {
    int index = options.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last options. The list is empty.");
    return setNewOptionLike(index, buildOption(index));
  }
  public OptionsNested<A> editMatchingOption(Predicate<OptionsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<options.size();i++) { 
    if (predicate.test(options.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching options. No match found.");
    return setNewOptionLike(index, buildOption(index));
  }
  public A addToSearches(int index,String item) {
    if (this.searches == null) {this.searches = new ArrayList<String>();}
    this.searches.add(index, item);
    return (A)this;
  }
  public A setToSearches(int index,String item) {
    if (this.searches == null) {this.searches = new ArrayList<String>();}
    this.searches.set(index, item); return (A)this;
  }
  public A addToSearches(java.lang.String... items) {
    if (this.searches == null) {this.searches = new ArrayList<String>();}
    for (String item : items) {this.searches.add(item);} return (A)this;
  }
  public A addAllToSearches(Collection<String> items) {
    if (this.searches == null) {this.searches = new ArrayList<String>();}
    for (String item : items) {this.searches.add(item);} return (A)this;
  }
  public A removeFromSearches(java.lang.String... items) {
    if (this.searches == null) return (A)this;
    for (String item : items) { this.searches.remove(item);} return (A)this;
  }
  public A removeAllFromSearches(Collection<String> items) {
    if (this.searches == null) return (A)this;
    for (String item : items) { this.searches.remove(item);} return (A)this;
  }
  public List<String> getSearches() {
    return this.searches;
  }
  public String getSearch(int index) {
    return this.searches.get(index);
  }
  public String getFirstSearch() {
    return this.searches.get(0);
  }
  public String getLastSearch() {
    return this.searches.get(searches.size() - 1);
  }
  public String getMatchingSearch(Predicate<String> predicate) {
    for (String item: searches) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingSearch(Predicate<String> predicate) {
    for (String item: searches) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSearches(List<String> searches) {
    if (searches != null) {this.searches = new ArrayList(); for (String item : searches){this.addToSearches(item);}} else { this.searches = null;} return (A) this;
  }
  public A withSearches(java.lang.String... searches) {
    if (this.searches != null) {this.searches.clear(); _visitables.remove("searches"); }
    if (searches != null) {for (String item :searches){ this.addToSearches(item);}} return (A) this;
  }
  public boolean hasSearches() {
    return searches != null && !searches.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DnsConfigFluent that = (DnsConfigFluent) o;
    if (!java.util.Objects.equals(nameservers, that.nameservers)) return false;

    if (!java.util.Objects.equals(options, that.options)) return false;

    if (!java.util.Objects.equals(searches, that.searches)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(nameservers,  options,  searches,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nameservers != null && !nameservers.isEmpty()) { sb.append("nameservers:"); sb.append(nameservers + ","); }
    if (options != null && !options.isEmpty()) { sb.append("options:"); sb.append(options + ","); }
    if (searches != null && !searches.isEmpty()) { sb.append("searches:"); sb.append(searches); }
    sb.append("}");
    return sb.toString();
  }
  public class OptionsNested<N> extends OptionsFluent<OptionsNested<N>> implements Nested<N>{
    OptionsNested(int index,Options item) {
      this.index = index;
      this.builder = new OptionsBuilder(this, item);
    }
    OptionsBuilder builder;
    int index;
    public N and() {
      return (N) DnsConfigFluent.this.setToOptions(index,builder.build());
    }
    public N endOption() {
      return and();
    }
    
  }
  
}