package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HostAliasesBuilder extends HostAliasesFluent<HostAliasesBuilder> implements VisitableBuilder<HostAliases,HostAliasesBuilder>{
  public HostAliasesBuilder() {
    this(false);
  }
  public HostAliasesBuilder(Boolean validationEnabled) {
    this(new HostAliases(), validationEnabled);
  }
  public HostAliasesBuilder(HostAliasesFluent<?> fluent) {
    this(fluent, false);
  }
  public HostAliasesBuilder(HostAliasesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HostAliases(), validationEnabled);
  }
  public HostAliasesBuilder(HostAliasesFluent<?> fluent,HostAliases instance) {
    this(fluent, instance, false);
  }
  public HostAliasesBuilder(HostAliasesFluent<?> fluent,HostAliases instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HostAliases());

    if (instance != null) {
      fluent.withHostnames(instance.getHostnames());
      fluent.withIp(instance.getIp());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HostAliasesBuilder(HostAliases instance) {
    this(instance,false);
  }
  public HostAliasesBuilder(HostAliases instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HostAliases());

    if (instance != null) {
      this.withHostnames(instance.getHostnames());
      this.withIp(instance.getIp());
    }
    this.validationEnabled = validationEnabled; 
  }
  HostAliasesFluent<?> fluent;
  Boolean validationEnabled;
  public HostAliases build() {
    HostAliases buildable = new HostAliases();
    buildable.setHostnames(fluent.getHostnames());
    buildable.setIp(fluent.getIp());
    return buildable;
  }
  
}