package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InitContainersBuilder extends InitContainersFluent<InitContainersBuilder> implements VisitableBuilder<InitContainers,InitContainersBuilder>{
  public InitContainersBuilder() {
    this(false);
  }
  public InitContainersBuilder(Boolean validationEnabled) {
    this(new InitContainers(), validationEnabled);
  }
  public InitContainersBuilder(InitContainersFluent<?> fluent) {
    this(fluent, false);
  }
  public InitContainersBuilder(InitContainersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InitContainers(), validationEnabled);
  }
  public InitContainersBuilder(InitContainersFluent<?> fluent,InitContainers instance) {
    this(fluent, instance, false);
  }
  public InitContainersBuilder(InitContainersFluent<?> fluent,InitContainers instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new InitContainers());

    if (instance != null) {
      fluent.withArgs(instance.getArgs());
      fluent.withCommand(instance.getCommand());
      fluent.withEnv(instance.getEnv());
      fluent.withEnvFrom(instance.getEnvFrom());
      fluent.withImage(instance.getImage());
      fluent.withImagePullPolicy(instance.getImagePullPolicy());
      fluent.withLifecycle(instance.getLifecycle());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withName(instance.getName());
      fluent.withPorts(instance.getPorts());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withResources(instance.getResources());
      fluent.withSecurityContext(instance.getSecurityContext());
      fluent.withStartupProbe(instance.getStartupProbe());
      fluent.withStdin(instance.getStdin());
      fluent.withStdinOnce(instance.getStdinOnce());
      fluent.withTerminationMessagePath(instance.getTerminationMessagePath());
      fluent.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
      fluent.withTty(instance.getTty());
      fluent.withVolumeDevices(instance.getVolumeDevices());
      fluent.withVolumeMounts(instance.getVolumeMounts());
      fluent.withWorkingDir(instance.getWorkingDir());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InitContainersBuilder(InitContainers instance) {
    this(instance,false);
  }
  public InitContainersBuilder(InitContainers instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new InitContainers());

    if (instance != null) {
      this.withArgs(instance.getArgs());
      this.withCommand(instance.getCommand());
      this.withEnv(instance.getEnv());
      this.withEnvFrom(instance.getEnvFrom());
      this.withImage(instance.getImage());
      this.withImagePullPolicy(instance.getImagePullPolicy());
      this.withLifecycle(instance.getLifecycle());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withName(instance.getName());
      this.withPorts(instance.getPorts());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withResources(instance.getResources());
      this.withSecurityContext(instance.getSecurityContext());
      this.withStartupProbe(instance.getStartupProbe());
      this.withStdin(instance.getStdin());
      this.withStdinOnce(instance.getStdinOnce());
      this.withTerminationMessagePath(instance.getTerminationMessagePath());
      this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
      this.withTty(instance.getTty());
      this.withVolumeDevices(instance.getVolumeDevices());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withWorkingDir(instance.getWorkingDir());
    }
    this.validationEnabled = validationEnabled; 
  }
  InitContainersFluent<?> fluent;
  Boolean validationEnabled;
  public InitContainers build() {
    InitContainers buildable = new InitContainers();
    buildable.setArgs(fluent.getArgs());
    buildable.setCommand(fluent.getCommand());
    buildable.setEnv(fluent.buildEnv());
    buildable.setEnvFrom(fluent.buildEnvFrom());
    buildable.setImage(fluent.getImage());
    buildable.setImagePullPolicy(fluent.getImagePullPolicy());
    buildable.setLifecycle(fluent.buildLifecycle());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setName(fluent.getName());
    buildable.setPorts(fluent.buildPorts());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setResources(fluent.buildResources());
    buildable.setSecurityContext(fluent.buildSecurityContext());
    buildable.setStartupProbe(fluent.buildStartupProbe());
    buildable.setStdin(fluent.getStdin());
    buildable.setStdinOnce(fluent.getStdinOnce());
    buildable.setTerminationMessagePath(fluent.getTerminationMessagePath());
    buildable.setTerminationMessagePolicy(fluent.getTerminationMessagePolicy());
    buildable.setTty(fluent.getTty());
    buildable.setVolumeDevices(fluent.buildVolumeDevices());
    buildable.setVolumeMounts(fluent.buildVolumeMounts());
    buildable.setWorkingDir(fluent.getWorkingDir());
    return buildable;
  }
  
}