package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OsBuilder extends OsFluent<OsBuilder> implements VisitableBuilder<Os,OsBuilder>{
  public OsBuilder() {
    this(false);
  }
  public OsBuilder(Boolean validationEnabled) {
    this(new Os(), validationEnabled);
  }
  public OsBuilder(OsFluent<?> fluent) {
    this(fluent, false);
  }
  public OsBuilder(OsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Os(), validationEnabled);
  }
  public OsBuilder(OsFluent<?> fluent,Os instance) {
    this(fluent, instance, false);
  }
  public OsBuilder(OsFluent<?> fluent,Os instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Os());

    if (instance != null) {
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OsBuilder(Os instance) {
    this(instance,false);
  }
  public OsBuilder(Os instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Os());

    if (instance != null) {
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  OsFluent<?> fluent;
  Boolean validationEnabled;
  public Os build() {
    Os buildable = new Os();
    buildable.setName(fluent.getName());
    return buildable;
  }
  
}