package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReadinessGatesBuilder extends ReadinessGatesFluent<ReadinessGatesBuilder> implements VisitableBuilder<ReadinessGates,ReadinessGatesBuilder>{
  public ReadinessGatesBuilder() {
    this(false);
  }
  public ReadinessGatesBuilder(Boolean validationEnabled) {
    this(new ReadinessGates(), validationEnabled);
  }
  public ReadinessGatesBuilder(ReadinessGatesFluent<?> fluent) {
    this(fluent, false);
  }
  public ReadinessGatesBuilder(ReadinessGatesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReadinessGates(), validationEnabled);
  }
  public ReadinessGatesBuilder(ReadinessGatesFluent<?> fluent,ReadinessGates instance) {
    this(fluent, instance, false);
  }
  public ReadinessGatesBuilder(ReadinessGatesFluent<?> fluent,ReadinessGates instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ReadinessGates());

    if (instance != null) {
      fluent.withConditionType(instance.getConditionType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReadinessGatesBuilder(ReadinessGates instance) {
    this(instance,false);
  }
  public ReadinessGatesBuilder(ReadinessGates instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ReadinessGates());

    if (instance != null) {
      this.withConditionType(instance.getConditionType());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReadinessGatesFluent<?> fluent;
  Boolean validationEnabled;
  public ReadinessGates build() {
    ReadinessGates buildable = new ReadinessGates();
    buildable.setConditionType(fluent.getConditionType());
    return buildable;
  }
  
}