package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecurityContextBuilder extends SecurityContextFluent<SecurityContextBuilder> implements VisitableBuilder<SecurityContext,SecurityContextBuilder>{
  public SecurityContextBuilder() {
    this(false);
  }
  public SecurityContextBuilder(Boolean validationEnabled) {
    this(new SecurityContext(), validationEnabled);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent) {
    this(fluent, false);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecurityContext(), validationEnabled);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent,SecurityContext instance) {
    this(fluent, instance, false);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent,SecurityContext instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SecurityContext());

    if (instance != null) {
      fluent.withFsGroup(instance.getFsGroup());
      fluent.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
      fluent.withRunAsGroup(instance.getRunAsGroup());
      fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
      fluent.withRunAsUser(instance.getRunAsUser());
      fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
      fluent.withSeccompProfile(instance.getSeccompProfile());
      fluent.withSupplementalGroups(instance.getSupplementalGroups());
      fluent.withSysctls(instance.getSysctls());
      fluent.withWindowsOptions(instance.getWindowsOptions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecurityContextBuilder(SecurityContext instance) {
    this(instance,false);
  }
  public SecurityContextBuilder(SecurityContext instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SecurityContext());

    if (instance != null) {
      this.withFsGroup(instance.getFsGroup());
      this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
      this.withRunAsGroup(instance.getRunAsGroup());
      this.withRunAsNonRoot(instance.getRunAsNonRoot());
      this.withRunAsUser(instance.getRunAsUser());
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withSeccompProfile(instance.getSeccompProfile());
      this.withSupplementalGroups(instance.getSupplementalGroups());
      this.withSysctls(instance.getSysctls());
      this.withWindowsOptions(instance.getWindowsOptions());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecurityContextFluent<?> fluent;
  Boolean validationEnabled;
  public SecurityContext build() {
    SecurityContext buildable = new SecurityContext();
    buildable.setFsGroup(fluent.getFsGroup());
    buildable.setFsGroupChangePolicy(fluent.getFsGroupChangePolicy());
    buildable.setRunAsGroup(fluent.getRunAsGroup());
    buildable.setRunAsNonRoot(fluent.getRunAsNonRoot());
    buildable.setRunAsUser(fluent.getRunAsUser());
    buildable.setSeLinuxOptions(fluent.buildSeLinuxOptions());
    buildable.setSeccompProfile(fluent.buildSeccompProfile());
    buildable.setSupplementalGroups(fluent.getSupplementalGroups());
    buildable.setSysctls(fluent.buildSysctls());
    buildable.setWindowsOptions(fluent.buildWindowsOptions());
    return buildable;
  }
  
}