package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.Sysctls;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.SeccompProfile;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.SeccompProfileBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.SeLinuxOptionsBuilder;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.SeLinuxOptions;
import java.util.List;
import java.lang.Boolean;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.WindowsOptionsFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.SysctlsBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.WindowsOptionsBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.SeLinuxOptionsFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.WindowsOptions;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.SeccompProfileFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.SysctlsFluent;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SecurityContextFluent<A extends SecurityContextFluent<A>> extends BaseFluent<A>{
  public SecurityContextFluent() {
  }
  public SecurityContextFluent(SecurityContext instance) {
    instance = (instance != null ? instance : new SecurityContext());

    if (instance != null) {
      this.withFsGroup(instance.getFsGroup());
      this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
      this.withRunAsGroup(instance.getRunAsGroup());
      this.withRunAsNonRoot(instance.getRunAsNonRoot());
      this.withRunAsUser(instance.getRunAsUser());
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withSeccompProfile(instance.getSeccompProfile());
      this.withSupplementalGroups(instance.getSupplementalGroups());
      this.withSysctls(instance.getSysctls());
      this.withWindowsOptions(instance.getWindowsOptions());
    }
  }
  private Long fsGroup;
  private String fsGroupChangePolicy;
  private Long runAsGroup;
  private Boolean runAsNonRoot;
  private Long runAsUser;
  private SeLinuxOptionsBuilder seLinuxOptions;
  private SeccompProfileBuilder seccompProfile;
  private List<Long> supplementalGroups;
  private ArrayList<SysctlsBuilder> sysctls;
  private WindowsOptionsBuilder windowsOptions;
  public Long getFsGroup() {
    return this.fsGroup;
  }
  public A withFsGroup(Long fsGroup) {
    this.fsGroup=fsGroup; return (A) this;
  }
  public boolean hasFsGroup() {
    return this.fsGroup != null;
  }
  public String getFsGroupChangePolicy() {
    return this.fsGroupChangePolicy;
  }
  public A withFsGroupChangePolicy(String fsGroupChangePolicy) {
    this.fsGroupChangePolicy=fsGroupChangePolicy; return (A) this;
  }
  public boolean hasFsGroupChangePolicy() {
    return this.fsGroupChangePolicy != null;
  }
  public Long getRunAsGroup() {
    return this.runAsGroup;
  }
  public A withRunAsGroup(Long runAsGroup) {
    this.runAsGroup=runAsGroup; return (A) this;
  }
  public boolean hasRunAsGroup() {
    return this.runAsGroup != null;
  }
  public Boolean getRunAsNonRoot() {
    return this.runAsNonRoot;
  }
  public A withRunAsNonRoot(Boolean runAsNonRoot) {
    this.runAsNonRoot=runAsNonRoot; return (A) this;
  }
  public boolean hasRunAsNonRoot() {
    return this.runAsNonRoot != null;
  }
  public Long getRunAsUser() {
    return this.runAsUser;
  }
  public A withRunAsUser(Long runAsUser) {
    this.runAsUser=runAsUser; return (A) this;
  }
  public boolean hasRunAsUser() {
    return this.runAsUser != null;
  }
  public SeLinuxOptions buildSeLinuxOptions() {
    return this.seLinuxOptions!=null ?this.seLinuxOptions.build():null;
  }
  public A withSeLinuxOptions(SeLinuxOptions seLinuxOptions) {
    _visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
    if (seLinuxOptions!=null){ this.seLinuxOptions= new SeLinuxOptionsBuilder(seLinuxOptions); _visitables.get("seLinuxOptions").add(this.seLinuxOptions);} else { this.seLinuxOptions = null; _visitables.get("seLinuxOptions").remove(this.seLinuxOptions); } return (A) this;
  }
  public boolean hasSeLinuxOptions() {
    return this.seLinuxOptions != null;
  }
  public SpecSeLinuxOptionsNested<A> withNewSpecSeLinuxOptions() {
    return new SpecSeLinuxOptionsNested(null);
  }
  public SpecSeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SeLinuxOptions item) {
    return new SpecSeLinuxOptionsNested(item);
  }
  public SpecSeLinuxOptionsNested<A> editSpecSeLinuxOptions() {
    return withNewSeLinuxOptionsLike(java.util.Optional.ofNullable(buildSeLinuxOptions()).orElse(null));
  }
  public SpecSeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
    return withNewSeLinuxOptionsLike(java.util.Optional.ofNullable(buildSeLinuxOptions()).orElse(new SeLinuxOptionsBuilder().build()));
  }
  public SpecSeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SeLinuxOptions item) {
    return withNewSeLinuxOptionsLike(java.util.Optional.ofNullable(buildSeLinuxOptions()).orElse(item));
  }
  public SeccompProfile buildSeccompProfile() {
    return this.seccompProfile!=null ?this.seccompProfile.build():null;
  }
  public A withSeccompProfile(SeccompProfile seccompProfile) {
    _visitables.get("seccompProfile").remove(this.seccompProfile);
    if (seccompProfile!=null){ this.seccompProfile= new SeccompProfileBuilder(seccompProfile); _visitables.get("seccompProfile").add(this.seccompProfile);} else { this.seccompProfile = null; _visitables.get("seccompProfile").remove(this.seccompProfile); } return (A) this;
  }
  public boolean hasSeccompProfile() {
    return this.seccompProfile != null;
  }
  public SpecSeccompProfileNested<A> withNewSpecSeccompProfile() {
    return new SpecSeccompProfileNested(null);
  }
  public SpecSeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item) {
    return new SpecSeccompProfileNested(item);
  }
  public SpecSeccompProfileNested<A> editSpecSeccompProfile() {
    return withNewSeccompProfileLike(java.util.Optional.ofNullable(buildSeccompProfile()).orElse(null));
  }
  public SpecSeccompProfileNested<A> editOrNewSeccompProfile() {
    return withNewSeccompProfileLike(java.util.Optional.ofNullable(buildSeccompProfile()).orElse(new SeccompProfileBuilder().build()));
  }
  public SpecSeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item) {
    return withNewSeccompProfileLike(java.util.Optional.ofNullable(buildSeccompProfile()).orElse(item));
  }
  public A addToSupplementalGroups(int index,Long item) {
    if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
    this.supplementalGroups.add(index, item);
    return (A)this;
  }
  public A setToSupplementalGroups(int index,Long item) {
    if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
    this.supplementalGroups.set(index, item); return (A)this;
  }
  public A addToSupplementalGroups(java.lang.Long... items) {
    if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
    for (Long item : items) {this.supplementalGroups.add(item);} return (A)this;
  }
  public A addAllToSupplementalGroups(Collection<Long> items) {
    if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
    for (Long item : items) {this.supplementalGroups.add(item);} return (A)this;
  }
  public A removeFromSupplementalGroups(java.lang.Long... items) {
    if (this.supplementalGroups == null) return (A)this;
    for (Long item : items) { this.supplementalGroups.remove(item);} return (A)this;
  }
  public A removeAllFromSupplementalGroups(Collection<Long> items) {
    if (this.supplementalGroups == null) return (A)this;
    for (Long item : items) { this.supplementalGroups.remove(item);} return (A)this;
  }
  public List<Long> getSupplementalGroups() {
    return this.supplementalGroups;
  }
  public Long getSupplementalGroup(int index) {
    return this.supplementalGroups.get(index);
  }
  public Long getFirstSupplementalGroup() {
    return this.supplementalGroups.get(0);
  }
  public Long getLastSupplementalGroup() {
    return this.supplementalGroups.get(supplementalGroups.size() - 1);
  }
  public Long getMatchingSupplementalGroup(Predicate<Long> predicate) {
    for (Long item: supplementalGroups) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingSupplementalGroup(Predicate<Long> predicate) {
    for (Long item: supplementalGroups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSupplementalGroups(List<Long> supplementalGroups) {
    if (supplementalGroups != null) {this.supplementalGroups = new ArrayList(); for (Long item : supplementalGroups){this.addToSupplementalGroups(item);}} else { this.supplementalGroups = null;} return (A) this;
  }
  public A withSupplementalGroups(java.lang.Long... supplementalGroups) {
    if (this.supplementalGroups != null) {this.supplementalGroups.clear(); _visitables.remove("supplementalGroups"); }
    if (supplementalGroups != null) {for (Long item :supplementalGroups){ this.addToSupplementalGroups(item);}} return (A) this;
  }
  public boolean hasSupplementalGroups() {
    return supplementalGroups != null && !supplementalGroups.isEmpty();
  }
  public A addToSysctls(int index,Sysctls item) {
    if (this.sysctls == null) {this.sysctls = new ArrayList<SysctlsBuilder>();}
    SysctlsBuilder builder = new SysctlsBuilder(item);
    if (index < 0 || index >= sysctls.size()) { _visitables.get("sysctls").add(builder); sysctls.add(builder); } else { _visitables.get("sysctls").add(index, builder); sysctls.add(index, builder);}
    return (A)this;
  }
  public A setToSysctls(int index,Sysctls item) {
    if (this.sysctls == null) {this.sysctls = new ArrayList<SysctlsBuilder>();}
    SysctlsBuilder builder = new SysctlsBuilder(item);
    if (index < 0 || index >= sysctls.size()) { _visitables.get("sysctls").add(builder); sysctls.add(builder); } else { _visitables.get("sysctls").set(index, builder); sysctls.set(index, builder);}
    return (A)this;
  }
  public A addToSysctls(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.Sysctls... items) {
    if (this.sysctls == null) {this.sysctls = new ArrayList<SysctlsBuilder>();}
    for (Sysctls item : items) {SysctlsBuilder builder = new SysctlsBuilder(item);_visitables.get("sysctls").add(builder);this.sysctls.add(builder);} return (A)this;
  }
  public A addAllToSysctls(Collection<Sysctls> items) {
    if (this.sysctls == null) {this.sysctls = new ArrayList<SysctlsBuilder>();}
    for (Sysctls item : items) {SysctlsBuilder builder = new SysctlsBuilder(item);_visitables.get("sysctls").add(builder);this.sysctls.add(builder);} return (A)this;
  }
  public A removeFromSysctls(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.Sysctls... items) {
    if (this.sysctls == null) return (A)this;
    for (Sysctls item : items) {SysctlsBuilder builder = new SysctlsBuilder(item);_visitables.get("sysctls").remove(builder); this.sysctls.remove(builder);} return (A)this;
  }
  public A removeAllFromSysctls(Collection<Sysctls> items) {
    if (this.sysctls == null) return (A)this;
    for (Sysctls item : items) {SysctlsBuilder builder = new SysctlsBuilder(item);_visitables.get("sysctls").remove(builder); this.sysctls.remove(builder);} return (A)this;
  }
  public A removeMatchingFromSysctls(Predicate<SysctlsBuilder> predicate) {
    if (sysctls == null) return (A) this;
    final Iterator<SysctlsBuilder> each = sysctls.iterator();
    final List visitables = _visitables.get("sysctls");
    while (each.hasNext()) {
      SysctlsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Sysctls> buildSysctls() {
    return sysctls != null ? build(sysctls) : null;
  }
  public Sysctls buildSysctl(int index) {
    return this.sysctls.get(index).build();
  }
  public Sysctls buildFirstSysctl() {
    return this.sysctls.get(0).build();
  }
  public Sysctls buildLastSysctl() {
    return this.sysctls.get(sysctls.size() - 1).build();
  }
  public Sysctls buildMatchingSysctl(Predicate<SysctlsBuilder> predicate) {
    for (SysctlsBuilder item: sysctls) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingSysctl(Predicate<SysctlsBuilder> predicate) {
    for (SysctlsBuilder item: sysctls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSysctls(List<Sysctls> sysctls) {
    if (this.sysctls != null) { _visitables.get("sysctls").clear();}
    if (sysctls != null) {this.sysctls = new ArrayList(); for (Sysctls item : sysctls){this.addToSysctls(item);}} else { this.sysctls = null;} return (A) this;
  }
  public A withSysctls(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext.Sysctls... sysctls) {
    if (this.sysctls != null) {this.sysctls.clear(); _visitables.remove("sysctls"); }
    if (sysctls != null) {for (Sysctls item :sysctls){ this.addToSysctls(item);}} return (A) this;
  }
  public boolean hasSysctls() {
    return sysctls != null && !sysctls.isEmpty();
  }
  public SysctlsNested<A> addNewSysctl() {
    return new SysctlsNested(-1, null);
  }
  public SysctlsNested<A> addNewSysctlLike(Sysctls item) {
    return new SysctlsNested(-1, item);
  }
  public SysctlsNested<A> setNewSysctlLike(int index,Sysctls item) {
    return new SysctlsNested(index, item);
  }
  public SysctlsNested<A> editSysctl(int index) {
    if (sysctls.size() <= index) throw new RuntimeException("Can't edit sysctls. Index exceeds size.");
    return setNewSysctlLike(index, buildSysctl(index));
  }
  public SysctlsNested<A> editFirstSysctl() {
    if (sysctls.size() == 0) throw new RuntimeException("Can't edit first sysctls. The list is empty.");
    return setNewSysctlLike(0, buildSysctl(0));
  }
  public SysctlsNested<A> editLastSysctl() {
    int index = sysctls.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sysctls. The list is empty.");
    return setNewSysctlLike(index, buildSysctl(index));
  }
  public SysctlsNested<A> editMatchingSysctl(Predicate<SysctlsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sysctls.size();i++) { 
    if (predicate.test(sysctls.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sysctls. No match found.");
    return setNewSysctlLike(index, buildSysctl(index));
  }
  public WindowsOptions buildWindowsOptions() {
    return this.windowsOptions!=null ?this.windowsOptions.build():null;
  }
  public A withWindowsOptions(WindowsOptions windowsOptions) {
    _visitables.get("windowsOptions").remove(this.windowsOptions);
    if (windowsOptions!=null){ this.windowsOptions= new WindowsOptionsBuilder(windowsOptions); _visitables.get("windowsOptions").add(this.windowsOptions);} else { this.windowsOptions = null; _visitables.get("windowsOptions").remove(this.windowsOptions); } return (A) this;
  }
  public boolean hasWindowsOptions() {
    return this.windowsOptions != null;
  }
  public SpecWindowsOptionsNested<A> withNewSpecWindowsOptions() {
    return new SpecWindowsOptionsNested(null);
  }
  public SpecWindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsOptions item) {
    return new SpecWindowsOptionsNested(item);
  }
  public SpecWindowsOptionsNested<A> editSpecWindowsOptions() {
    return withNewWindowsOptionsLike(java.util.Optional.ofNullable(buildWindowsOptions()).orElse(null));
  }
  public SpecWindowsOptionsNested<A> editOrNewWindowsOptions() {
    return withNewWindowsOptionsLike(java.util.Optional.ofNullable(buildWindowsOptions()).orElse(new WindowsOptionsBuilder().build()));
  }
  public SpecWindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsOptions item) {
    return withNewWindowsOptionsLike(java.util.Optional.ofNullable(buildWindowsOptions()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecurityContextFluent that = (SecurityContextFluent) o;
    if (!java.util.Objects.equals(fsGroup, that.fsGroup)) return false;

    if (!java.util.Objects.equals(fsGroupChangePolicy, that.fsGroupChangePolicy)) return false;

    if (!java.util.Objects.equals(runAsGroup, that.runAsGroup)) return false;

    if (!java.util.Objects.equals(runAsNonRoot, that.runAsNonRoot)) return false;

    if (!java.util.Objects.equals(runAsUser, that.runAsUser)) return false;

    if (!java.util.Objects.equals(seLinuxOptions, that.seLinuxOptions)) return false;

    if (!java.util.Objects.equals(seccompProfile, that.seccompProfile)) return false;

    if (!java.util.Objects.equals(supplementalGroups, that.supplementalGroups)) return false;

    if (!java.util.Objects.equals(sysctls, that.sysctls)) return false;

    if (!java.util.Objects.equals(windowsOptions, that.windowsOptions)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fsGroup,  fsGroupChangePolicy,  runAsGroup,  runAsNonRoot,  runAsUser,  seLinuxOptions,  seccompProfile,  supplementalGroups,  sysctls,  windowsOptions,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fsGroup != null) { sb.append("fsGroup:"); sb.append(fsGroup + ","); }
    if (fsGroupChangePolicy != null) { sb.append("fsGroupChangePolicy:"); sb.append(fsGroupChangePolicy + ","); }
    if (runAsGroup != null) { sb.append("runAsGroup:"); sb.append(runAsGroup + ","); }
    if (runAsNonRoot != null) { sb.append("runAsNonRoot:"); sb.append(runAsNonRoot + ","); }
    if (runAsUser != null) { sb.append("runAsUser:"); sb.append(runAsUser + ","); }
    if (seLinuxOptions != null) { sb.append("seLinuxOptions:"); sb.append(seLinuxOptions + ","); }
    if (seccompProfile != null) { sb.append("seccompProfile:"); sb.append(seccompProfile + ","); }
    if (supplementalGroups != null && !supplementalGroups.isEmpty()) { sb.append("supplementalGroups:"); sb.append(supplementalGroups + ","); }
    if (sysctls != null && !sysctls.isEmpty()) { sb.append("sysctls:"); sb.append(sysctls + ","); }
    if (windowsOptions != null) { sb.append("windowsOptions:"); sb.append(windowsOptions); }
    sb.append("}");
    return sb.toString();
  }
  public A withRunAsNonRoot() {
    return withRunAsNonRoot(true);
  }
  public class SpecSeLinuxOptionsNested<N> extends SeLinuxOptionsFluent<SpecSeLinuxOptionsNested<N>> implements Nested<N>{
    SpecSeLinuxOptionsNested(SeLinuxOptions item) {
      this.builder = new SeLinuxOptionsBuilder(this, item);
    }
    SeLinuxOptionsBuilder builder;
    public N and() {
      return (N) SecurityContextFluent.this.withSeLinuxOptions(builder.build());
    }
    public N endSpecSeLinuxOptions() {
      return and();
    }
    
  }
  public class SpecSeccompProfileNested<N> extends SeccompProfileFluent<SpecSeccompProfileNested<N>> implements Nested<N>{
    SpecSeccompProfileNested(SeccompProfile item) {
      this.builder = new SeccompProfileBuilder(this, item);
    }
    SeccompProfileBuilder builder;
    public N and() {
      return (N) SecurityContextFluent.this.withSeccompProfile(builder.build());
    }
    public N endSpecSeccompProfile() {
      return and();
    }
    
  }
  public class SysctlsNested<N> extends SysctlsFluent<SysctlsNested<N>> implements Nested<N>{
    SysctlsNested(int index,Sysctls item) {
      this.index = index;
      this.builder = new SysctlsBuilder(this, item);
    }
    SysctlsBuilder builder;
    int index;
    public N and() {
      return (N) SecurityContextFluent.this.setToSysctls(index,builder.build());
    }
    public N endSysctl() {
      return and();
    }
    
  }
  public class SpecWindowsOptionsNested<N> extends WindowsOptionsFluent<SpecWindowsOptionsNested<N>> implements Nested<N>{
    SpecWindowsOptionsNested(WindowsOptions item) {
      this.builder = new WindowsOptionsBuilder(this, item);
    }
    WindowsOptionsBuilder builder;
    public N and() {
      return (N) SecurityContextFluent.this.withWindowsOptions(builder.build());
    }
    public N endSpecWindowsOptions() {
      return and();
    }
    
  }
  
}