package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TolerationsBuilder extends TolerationsFluent<TolerationsBuilder> implements VisitableBuilder<Tolerations,TolerationsBuilder>{
  public TolerationsBuilder() {
    this(false);
  }
  public TolerationsBuilder(Boolean validationEnabled) {
    this(new Tolerations(), validationEnabled);
  }
  public TolerationsBuilder(TolerationsFluent<?> fluent) {
    this(fluent, false);
  }
  public TolerationsBuilder(TolerationsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Tolerations(), validationEnabled);
  }
  public TolerationsBuilder(TolerationsFluent<?> fluent,Tolerations instance) {
    this(fluent, instance, false);
  }
  public TolerationsBuilder(TolerationsFluent<?> fluent,Tolerations instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Tolerations());

    if (instance != null) {
      fluent.withEffect(instance.getEffect());
      fluent.withKey(instance.getKey());
      fluent.withOperator(instance.getOperator());
      fluent.withTolerationSeconds(instance.getTolerationSeconds());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TolerationsBuilder(Tolerations instance) {
    this(instance,false);
  }
  public TolerationsBuilder(Tolerations instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Tolerations());

    if (instance != null) {
      this.withEffect(instance.getEffect());
      this.withKey(instance.getKey());
      this.withOperator(instance.getOperator());
      this.withTolerationSeconds(instance.getTolerationSeconds());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  TolerationsFluent<?> fluent;
  Boolean validationEnabled;
  public Tolerations build() {
    Tolerations buildable = new Tolerations();
    buildable.setEffect(fluent.getEffect());
    buildable.setKey(fluent.getKey());
    buildable.setOperator(fluent.getOperator());
    buildable.setTolerationSeconds(fluent.getTolerationSeconds());
    buildable.setValue(fluent.getValue());
    return buildable;
  }
  
}