package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TopologySpreadConstraintsBuilder extends TopologySpreadConstraintsFluent<TopologySpreadConstraintsBuilder> implements VisitableBuilder<TopologySpreadConstraints,TopologySpreadConstraintsBuilder>{
  public TopologySpreadConstraintsBuilder() {
    this(false);
  }
  public TopologySpreadConstraintsBuilder(Boolean validationEnabled) {
    this(new TopologySpreadConstraints(), validationEnabled);
  }
  public TopologySpreadConstraintsBuilder(TopologySpreadConstraintsFluent<?> fluent) {
    this(fluent, false);
  }
  public TopologySpreadConstraintsBuilder(TopologySpreadConstraintsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TopologySpreadConstraints(), validationEnabled);
  }
  public TopologySpreadConstraintsBuilder(TopologySpreadConstraintsFluent<?> fluent,TopologySpreadConstraints instance) {
    this(fluent, instance, false);
  }
  public TopologySpreadConstraintsBuilder(TopologySpreadConstraintsFluent<?> fluent,TopologySpreadConstraints instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TopologySpreadConstraints());

    if (instance != null) {
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withMaxSkew(instance.getMaxSkew());
      fluent.withTopologyKey(instance.getTopologyKey());
      fluent.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TopologySpreadConstraintsBuilder(TopologySpreadConstraints instance) {
    this(instance,false);
  }
  public TopologySpreadConstraintsBuilder(TopologySpreadConstraints instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TopologySpreadConstraints());

    if (instance != null) {
      this.withLabelSelector(instance.getLabelSelector());
      this.withMaxSkew(instance.getMaxSkew());
      this.withTopologyKey(instance.getTopologyKey());
      this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());
    }
    this.validationEnabled = validationEnabled; 
  }
  TopologySpreadConstraintsFluent<?> fluent;
  Boolean validationEnabled;
  public TopologySpreadConstraints build() {
    TopologySpreadConstraints buildable = new TopologySpreadConstraints();
    buildable.setLabelSelector(fluent.buildLabelSelector());
    buildable.setMaxSkew(fluent.getMaxSkew());
    buildable.setTopologyKey(fluent.getTopologyKey());
    buildable.setWhenUnsatisfiable(fluent.getWhenUnsatisfiable());
    return buildable;
  }
  
}