package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumesBuilder extends VolumesFluent<VolumesBuilder> implements VisitableBuilder<Volumes,VolumesBuilder>{
  public VolumesBuilder() {
    this(false);
  }
  public VolumesBuilder(Boolean validationEnabled) {
    this(new Volumes(), validationEnabled);
  }
  public VolumesBuilder(VolumesFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumesBuilder(VolumesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Volumes(), validationEnabled);
  }
  public VolumesBuilder(VolumesFluent<?> fluent,Volumes instance) {
    this(fluent, instance, false);
  }
  public VolumesBuilder(VolumesFluent<?> fluent,Volumes instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Volumes());

    if (instance != null) {
      fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
      fluent.withAzureDisk(instance.getAzureDisk());
      fluent.withAzureFile(instance.getAzureFile());
      fluent.withCephfs(instance.getCephfs());
      fluent.withCinder(instance.getCinder());
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withCsi(instance.getCsi());
      fluent.withDownwardAPI(instance.getDownwardAPI());
      fluent.withEmptyDir(instance.getEmptyDir());
      fluent.withEphemeral(instance.getEphemeral());
      fluent.withFc(instance.getFc());
      fluent.withFlexVolume(instance.getFlexVolume());
      fluent.withFlocker(instance.getFlocker());
      fluent.withGcePersistentDisk(instance.getGcePersistentDisk());
      fluent.withGitRepo(instance.getGitRepo());
      fluent.withGlusterfs(instance.getGlusterfs());
      fluent.withHostPath(instance.getHostPath());
      fluent.withIscsi(instance.getIscsi());
      fluent.withName(instance.getName());
      fluent.withNfs(instance.getNfs());
      fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      fluent.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
      fluent.withPortworxVolume(instance.getPortworxVolume());
      fluent.withProjected(instance.getProjected());
      fluent.withQuobyte(instance.getQuobyte());
      fluent.withRbd(instance.getRbd());
      fluent.withScaleIO(instance.getScaleIO());
      fluent.withSecret(instance.getSecret());
      fluent.withStorageos(instance.getStorageos());
      fluent.withVsphereVolume(instance.getVsphereVolume());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VolumesBuilder(Volumes instance) {
    this(instance,false);
  }
  public VolumesBuilder(Volumes instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Volumes());

    if (instance != null) {
      this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
      this.withAzureDisk(instance.getAzureDisk());
      this.withAzureFile(instance.getAzureFile());
      this.withCephfs(instance.getCephfs());
      this.withCinder(instance.getCinder());
      this.withConfigMap(instance.getConfigMap());
      this.withCsi(instance.getCsi());
      this.withDownwardAPI(instance.getDownwardAPI());
      this.withEmptyDir(instance.getEmptyDir());
      this.withEphemeral(instance.getEphemeral());
      this.withFc(instance.getFc());
      this.withFlexVolume(instance.getFlexVolume());
      this.withFlocker(instance.getFlocker());
      this.withGcePersistentDisk(instance.getGcePersistentDisk());
      this.withGitRepo(instance.getGitRepo());
      this.withGlusterfs(instance.getGlusterfs());
      this.withHostPath(instance.getHostPath());
      this.withIscsi(instance.getIscsi());
      this.withName(instance.getName());
      this.withNfs(instance.getNfs());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
      this.withPortworxVolume(instance.getPortworxVolume());
      this.withProjected(instance.getProjected());
      this.withQuobyte(instance.getQuobyte());
      this.withRbd(instance.getRbd());
      this.withScaleIO(instance.getScaleIO());
      this.withSecret(instance.getSecret());
      this.withStorageos(instance.getStorageos());
      this.withVsphereVolume(instance.getVsphereVolume());
    }
    this.validationEnabled = validationEnabled; 
  }
  VolumesFluent<?> fluent;
  Boolean validationEnabled;
  public Volumes build() {
    Volumes buildable = new Volumes();
    buildable.setAwsElasticBlockStore(fluent.buildAwsElasticBlockStore());
    buildable.setAzureDisk(fluent.buildAzureDisk());
    buildable.setAzureFile(fluent.buildAzureFile());
    buildable.setCephfs(fluent.buildCephfs());
    buildable.setCinder(fluent.buildCinder());
    buildable.setConfigMap(fluent.buildConfigMap());
    buildable.setCsi(fluent.buildCsi());
    buildable.setDownwardAPI(fluent.buildDownwardAPI());
    buildable.setEmptyDir(fluent.buildEmptyDir());
    buildable.setEphemeral(fluent.buildEphemeral());
    buildable.setFc(fluent.buildFc());
    buildable.setFlexVolume(fluent.buildFlexVolume());
    buildable.setFlocker(fluent.buildFlocker());
    buildable.setGcePersistentDisk(fluent.buildGcePersistentDisk());
    buildable.setGitRepo(fluent.buildGitRepo());
    buildable.setGlusterfs(fluent.buildGlusterfs());
    buildable.setHostPath(fluent.buildHostPath());
    buildable.setIscsi(fluent.buildIscsi());
    buildable.setName(fluent.getName());
    buildable.setNfs(fluent.buildNfs());
    buildable.setPersistentVolumeClaim(fluent.buildPersistentVolumeClaim());
    buildable.setPhotonPersistentDisk(fluent.buildPhotonPersistentDisk());
    buildable.setPortworxVolume(fluent.buildPortworxVolume());
    buildable.setProjected(fluent.buildProjected());
    buildable.setQuobyte(fluent.buildQuobyte());
    buildable.setRbd(fluent.buildRbd());
    buildable.setScaleIO(fluent.buildScaleIO());
    buildable.setSecret(fluent.buildSecret());
    buildable.setStorageos(fluent.buildStorageos());
    buildable.setVsphereVolume(fluent.buildVsphereVolume());
    return buildable;
  }
  
}