package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.affinity;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodAntiAffinityBuilder extends PodAntiAffinityFluent<PodAntiAffinityBuilder> implements VisitableBuilder<PodAntiAffinity,PodAntiAffinityBuilder>{
  public PodAntiAffinityBuilder() {
    this(false);
  }
  public PodAntiAffinityBuilder(Boolean validationEnabled) {
    this(new PodAntiAffinity(), validationEnabled);
  }
  public PodAntiAffinityBuilder(PodAntiAffinityFluent<?> fluent) {
    this(fluent, false);
  }
  public PodAntiAffinityBuilder(PodAntiAffinityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodAntiAffinity(), validationEnabled);
  }
  public PodAntiAffinityBuilder(PodAntiAffinityFluent<?> fluent,PodAntiAffinity instance) {
    this(fluent, instance, false);
  }
  public PodAntiAffinityBuilder(PodAntiAffinityFluent<?> fluent,PodAntiAffinity instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodAntiAffinity());

    if (instance != null) {
      fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
      fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodAntiAffinityBuilder(PodAntiAffinity instance) {
    this(instance,false);
  }
  public PodAntiAffinityBuilder(PodAntiAffinity instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodAntiAffinity());

    if (instance != null) {
      this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
      this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodAntiAffinityFluent<?> fluent;
  Boolean validationEnabled;
  public PodAntiAffinity build() {
    PodAntiAffinity buildable = new PodAntiAffinity();
    buildable.setPreferredDuringSchedulingIgnoredDuringExecution(fluent.buildPreferredDuringSchedulingIgnoredDuringExecution());
    buildable.setRequiredDuringSchedulingIgnoredDuringExecution(fluent.buildRequiredDuringSchedulingIgnoredDuringExecution());
    return buildable;
  }
  
}