package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.affinity.podaffinity.preferredduringschedulingignoredduringexecution;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodAffinityTermBuilder extends PodAffinityTermFluent<PodAffinityTermBuilder> implements VisitableBuilder<PodAffinityTerm,PodAffinityTermBuilder>{
  public PodAffinityTermBuilder() {
    this(false);
  }
  public PodAffinityTermBuilder(Boolean validationEnabled) {
    this(new PodAffinityTerm(), validationEnabled);
  }
  public PodAffinityTermBuilder(PodAffinityTermFluent<?> fluent) {
    this(fluent, false);
  }
  public PodAffinityTermBuilder(PodAffinityTermFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodAffinityTerm(), validationEnabled);
  }
  public PodAffinityTermBuilder(PodAffinityTermFluent<?> fluent,PodAffinityTerm instance) {
    this(fluent, instance, false);
  }
  public PodAffinityTermBuilder(PodAffinityTermFluent<?> fluent,PodAffinityTerm instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodAffinityTerm());

    if (instance != null) {
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withNamespaceSelector(instance.getNamespaceSelector());
      fluent.withNamespaces(instance.getNamespaces());
      fluent.withTopologyKey(instance.getTopologyKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodAffinityTermBuilder(PodAffinityTerm instance) {
    this(instance,false);
  }
  public PodAffinityTermBuilder(PodAffinityTerm instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodAffinityTerm());

    if (instance != null) {
      this.withLabelSelector(instance.getLabelSelector());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withNamespaces(instance.getNamespaces());
      this.withTopologyKey(instance.getTopologyKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodAffinityTermFluent<?> fluent;
  Boolean validationEnabled;
  public PodAffinityTerm build() {
    PodAffinityTerm buildable = new PodAffinityTerm();
    buildable.setLabelSelector(fluent.buildLabelSelector());
    buildable.setNamespaceSelector(fluent.buildNamespaceSelector());
    buildable.setNamespaces(fluent.getNamespaces());
    buildable.setTopologyKey(fluent.getTopologyKey());
    return buildable;
  }
  
}