package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.affinity.podaffinity.requiredduringschedulingignoredduringexecution;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LabelSelectorBuilder extends LabelSelectorFluent<LabelSelectorBuilder> implements VisitableBuilder<LabelSelector,LabelSelectorBuilder>{
  public LabelSelectorBuilder() {
    this(false);
  }
  public LabelSelectorBuilder(Boolean validationEnabled) {
    this(new LabelSelector(), validationEnabled);
  }
  public LabelSelectorBuilder(LabelSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public LabelSelectorBuilder(LabelSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LabelSelector(), validationEnabled);
  }
  public LabelSelectorBuilder(LabelSelectorFluent<?> fluent,LabelSelector instance) {
    this(fluent, instance, false);
  }
  public LabelSelectorBuilder(LabelSelectorFluent<?> fluent,LabelSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LabelSelector());

    if (instance != null) {
      fluent.withMatchExpressions(instance.getMatchExpressions());
      fluent.withMatchLabels(instance.getMatchLabels());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LabelSelectorBuilder(LabelSelector instance) {
    this(instance,false);
  }
  public LabelSelectorBuilder(LabelSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LabelSelector());

    if (instance != null) {
      this.withMatchExpressions(instance.getMatchExpressions());
      this.withMatchLabels(instance.getMatchLabels());
    }
    this.validationEnabled = validationEnabled; 
  }
  LabelSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public LabelSelector build() {
    LabelSelector buildable = new LabelSelector();
    buildable.setMatchExpressions(fluent.buildMatchExpressions());
    buildable.setMatchLabels(fluent.getMatchLabels());
    return buildable;
  }
  
}