package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.containers;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvFromBuilder extends EnvFromFluent<EnvFromBuilder> implements VisitableBuilder<EnvFrom,EnvFromBuilder>{
  public EnvFromBuilder() {
    this(false);
  }
  public EnvFromBuilder(Boolean validationEnabled) {
    this(new EnvFrom(), validationEnabled);
  }
  public EnvFromBuilder(EnvFromFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvFromBuilder(EnvFromFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EnvFrom(), validationEnabled);
  }
  public EnvFromBuilder(EnvFromFluent<?> fluent,EnvFrom instance) {
    this(fluent, instance, false);
  }
  public EnvFromBuilder(EnvFromFluent<?> fluent,EnvFrom instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EnvFrom());

    if (instance != null) {
      fluent.withConfigMapRef(instance.getConfigMapRef());
      fluent.withPrefix(instance.getPrefix());
      fluent.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EnvFromBuilder(EnvFrom instance) {
    this(instance,false);
  }
  public EnvFromBuilder(EnvFrom instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EnvFrom());

    if (instance != null) {
      this.withConfigMapRef(instance.getConfigMapRef());
      this.withPrefix(instance.getPrefix());
      this.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  EnvFromFluent<?> fluent;
  Boolean validationEnabled;
  public EnvFrom build() {
    EnvFrom buildable = new EnvFrom();
    buildable.setConfigMapRef(fluent.buildConfigMapRef());
    buildable.setPrefix(fluent.getPrefix());
    buildable.setSecretRef(fluent.buildSecretRef());
    return buildable;
  }
  
}