package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.containers;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecurityContextBuilder extends SecurityContextFluent<SecurityContextBuilder> implements VisitableBuilder<SecurityContext,SecurityContextBuilder>{
  public SecurityContextBuilder() {
    this(false);
  }
  public SecurityContextBuilder(Boolean validationEnabled) {
    this(new SecurityContext(), validationEnabled);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent) {
    this(fluent, false);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecurityContext(), validationEnabled);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent,SecurityContext instance) {
    this(fluent, instance, false);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent,SecurityContext instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SecurityContext());

    if (instance != null) {
      fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
      fluent.withCapabilities(instance.getCapabilities());
      fluent.withPrivileged(instance.getPrivileged());
      fluent.withProcMount(instance.getProcMount());
      fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
      fluent.withRunAsGroup(instance.getRunAsGroup());
      fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
      fluent.withRunAsUser(instance.getRunAsUser());
      fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
      fluent.withSeccompProfile(instance.getSeccompProfile());
      fluent.withWindowsOptions(instance.getWindowsOptions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecurityContextBuilder(SecurityContext instance) {
    this(instance,false);
  }
  public SecurityContextBuilder(SecurityContext instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SecurityContext());

    if (instance != null) {
      this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
      this.withCapabilities(instance.getCapabilities());
      this.withPrivileged(instance.getPrivileged());
      this.withProcMount(instance.getProcMount());
      this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
      this.withRunAsGroup(instance.getRunAsGroup());
      this.withRunAsNonRoot(instance.getRunAsNonRoot());
      this.withRunAsUser(instance.getRunAsUser());
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withSeccompProfile(instance.getSeccompProfile());
      this.withWindowsOptions(instance.getWindowsOptions());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecurityContextFluent<?> fluent;
  Boolean validationEnabled;
  public SecurityContext build() {
    SecurityContext buildable = new SecurityContext();
    buildable.setAllowPrivilegeEscalation(fluent.getAllowPrivilegeEscalation());
    buildable.setCapabilities(fluent.buildCapabilities());
    buildable.setPrivileged(fluent.getPrivileged());
    buildable.setProcMount(fluent.getProcMount());
    buildable.setReadOnlyRootFilesystem(fluent.getReadOnlyRootFilesystem());
    buildable.setRunAsGroup(fluent.getRunAsGroup());
    buildable.setRunAsNonRoot(fluent.getRunAsNonRoot());
    buildable.setRunAsUser(fluent.getRunAsUser());
    buildable.setSeLinuxOptions(fluent.buildSeLinuxOptions());
    buildable.setSeccompProfile(fluent.buildSeccompProfile());
    buildable.setWindowsOptions(fluent.buildWindowsOptions());
    return buildable;
  }
  
}