package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.containers;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StartupProbeBuilder extends StartupProbeFluent<StartupProbeBuilder> implements VisitableBuilder<StartupProbe,StartupProbeBuilder>{
  public StartupProbeBuilder() {
    this(false);
  }
  public StartupProbeBuilder(Boolean validationEnabled) {
    this(new StartupProbe(), validationEnabled);
  }
  public StartupProbeBuilder(StartupProbeFluent<?> fluent) {
    this(fluent, false);
  }
  public StartupProbeBuilder(StartupProbeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StartupProbe(), validationEnabled);
  }
  public StartupProbeBuilder(StartupProbeFluent<?> fluent,StartupProbe instance) {
    this(fluent, instance, false);
  }
  public StartupProbeBuilder(StartupProbeFluent<?> fluent,StartupProbe instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StartupProbe());

    if (instance != null) {
      fluent.withExec(instance.getExec());
      fluent.withFailureThreshold(instance.getFailureThreshold());
      fluent.withGrpc(instance.getGrpc());
      fluent.withHttpGet(instance.getHttpGet());
      fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      fluent.withPeriodSeconds(instance.getPeriodSeconds());
      fluent.withSuccessThreshold(instance.getSuccessThreshold());
      fluent.withTcpSocket(instance.getTcpSocket());
      fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StartupProbeBuilder(StartupProbe instance) {
    this(instance,false);
  }
  public StartupProbeBuilder(StartupProbe instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StartupProbe());

    if (instance != null) {
      this.withExec(instance.getExec());
      this.withFailureThreshold(instance.getFailureThreshold());
      this.withGrpc(instance.getGrpc());
      this.withHttpGet(instance.getHttpGet());
      this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      this.withPeriodSeconds(instance.getPeriodSeconds());
      this.withSuccessThreshold(instance.getSuccessThreshold());
      this.withTcpSocket(instance.getTcpSocket());
      this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
    }
    this.validationEnabled = validationEnabled; 
  }
  StartupProbeFluent<?> fluent;
  Boolean validationEnabled;
  public StartupProbe build() {
    StartupProbe buildable = new StartupProbe();
    buildable.setExec(fluent.buildExec());
    buildable.setFailureThreshold(fluent.getFailureThreshold());
    buildable.setGrpc(fluent.buildGrpc());
    buildable.setHttpGet(fluent.buildHttpGet());
    buildable.setInitialDelaySeconds(fluent.getInitialDelaySeconds());
    buildable.setPeriodSeconds(fluent.getPeriodSeconds());
    buildable.setSuccessThreshold(fluent.getSuccessThreshold());
    buildable.setTcpSocket(fluent.buildTcpSocket());
    buildable.setTerminationGracePeriodSeconds(fluent.getTerminationGracePeriodSeconds());
    buildable.setTimeoutSeconds(fluent.getTimeoutSeconds());
    return buildable;
  }
  
}