package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.containers;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeDevicesBuilder extends VolumeDevicesFluent<VolumeDevicesBuilder> implements VisitableBuilder<VolumeDevices,VolumeDevicesBuilder>{
  public VolumeDevicesBuilder() {
    this(false);
  }
  public VolumeDevicesBuilder(Boolean validationEnabled) {
    this(new VolumeDevices(), validationEnabled);
  }
  public VolumeDevicesBuilder(VolumeDevicesFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeDevicesBuilder(VolumeDevicesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeDevices(), validationEnabled);
  }
  public VolumeDevicesBuilder(VolumeDevicesFluent<?> fluent,VolumeDevices instance) {
    this(fluent, instance, false);
  }
  public VolumeDevicesBuilder(VolumeDevicesFluent<?> fluent,VolumeDevices instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VolumeDevices());

    if (instance != null) {
      fluent.withDevicePath(instance.getDevicePath());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VolumeDevicesBuilder(VolumeDevices instance) {
    this(instance,false);
  }
  public VolumeDevicesBuilder(VolumeDevices instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VolumeDevices());

    if (instance != null) {
      this.withDevicePath(instance.getDevicePath());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  VolumeDevicesFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeDevices build() {
    VolumeDevices buildable = new VolumeDevices();
    buildable.setDevicePath(fluent.getDevicePath());
    buildable.setName(fluent.getName());
    return buildable;
  }
  
}