package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.containers;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeMountsBuilder extends VolumeMountsFluent<VolumeMountsBuilder> implements VisitableBuilder<VolumeMounts,VolumeMountsBuilder>{
  public VolumeMountsBuilder() {
    this(false);
  }
  public VolumeMountsBuilder(Boolean validationEnabled) {
    this(new VolumeMounts(), validationEnabled);
  }
  public VolumeMountsBuilder(VolumeMountsFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeMountsBuilder(VolumeMountsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeMounts(), validationEnabled);
  }
  public VolumeMountsBuilder(VolumeMountsFluent<?> fluent,VolumeMounts instance) {
    this(fluent, instance, false);
  }
  public VolumeMountsBuilder(VolumeMountsFluent<?> fluent,VolumeMounts instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VolumeMounts());

    if (instance != null) {
      fluent.withMountPath(instance.getMountPath());
      fluent.withMountPropagation(instance.getMountPropagation());
      fluent.withName(instance.getName());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSubPath(instance.getSubPath());
      fluent.withSubPathExpr(instance.getSubPathExpr());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VolumeMountsBuilder(VolumeMounts instance) {
    this(instance,false);
  }
  public VolumeMountsBuilder(VolumeMounts instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VolumeMounts());

    if (instance != null) {
      this.withMountPath(instance.getMountPath());
      this.withMountPropagation(instance.getMountPropagation());
      this.withName(instance.getName());
      this.withReadOnly(instance.getReadOnly());
      this.withSubPath(instance.getSubPath());
      this.withSubPathExpr(instance.getSubPathExpr());
    }
    this.validationEnabled = validationEnabled; 
  }
  VolumeMountsFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeMounts build() {
    VolumeMounts buildable = new VolumeMounts();
    buildable.setMountPath(fluent.getMountPath());
    buildable.setMountPropagation(fluent.getMountPropagation());
    buildable.setName(fluent.getName());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setSubPath(fluent.getSubPath());
    buildable.setSubPathExpr(fluent.getSubPathExpr());
    return buildable;
  }
  
}