package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.containers.lifecycle.prestop;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExecBuilder extends ExecFluent<ExecBuilder> implements VisitableBuilder<Exec,ExecBuilder>{
  public ExecBuilder() {
    this(false);
  }
  public ExecBuilder(Boolean validationEnabled) {
    this(new Exec(), validationEnabled);
  }
  public ExecBuilder(ExecFluent<?> fluent) {
    this(fluent, false);
  }
  public ExecBuilder(ExecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Exec(), validationEnabled);
  }
  public ExecBuilder(ExecFluent<?> fluent,Exec instance) {
    this(fluent, instance, false);
  }
  public ExecBuilder(ExecFluent<?> fluent,Exec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Exec());

    if (instance != null) {
      fluent.withCommand(instance.getCommand());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExecBuilder(Exec instance) {
    this(instance,false);
  }
  public ExecBuilder(Exec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Exec());

    if (instance != null) {
      this.withCommand(instance.getCommand());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExecFluent<?> fluent;
  Boolean validationEnabled;
  public Exec build() {
    Exec buildable = new Exec();
    buildable.setCommand(fluent.getCommand());
    return buildable;
  }
  
}