package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.containers.livenessprobe.httpget;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HttpHeadersBuilder extends HttpHeadersFluent<HttpHeadersBuilder> implements VisitableBuilder<HttpHeaders,HttpHeadersBuilder>{
  public HttpHeadersBuilder() {
    this(false);
  }
  public HttpHeadersBuilder(Boolean validationEnabled) {
    this(new HttpHeaders(), validationEnabled);
  }
  public HttpHeadersBuilder(HttpHeadersFluent<?> fluent) {
    this(fluent, false);
  }
  public HttpHeadersBuilder(HttpHeadersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HttpHeaders(), validationEnabled);
  }
  public HttpHeadersBuilder(HttpHeadersFluent<?> fluent,HttpHeaders instance) {
    this(fluent, instance, false);
  }
  public HttpHeadersBuilder(HttpHeadersFluent<?> fluent,HttpHeaders instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HttpHeaders());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HttpHeadersBuilder(HttpHeaders instance) {
    this(instance,false);
  }
  public HttpHeadersBuilder(HttpHeaders instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HttpHeaders());

    if (instance != null) {
      this.withName(instance.getName());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  HttpHeadersFluent<?> fluent;
  Boolean validationEnabled;
  public HttpHeaders build() {
    HttpHeaders buildable = new HttpHeaders();
    buildable.setName(fluent.getName());
    buildable.setValue(fluent.getValue());
    return buildable;
  }
  
}