package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.containers.securitycontext;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CapabilitiesBuilder extends CapabilitiesFluent<CapabilitiesBuilder> implements VisitableBuilder<Capabilities,CapabilitiesBuilder>{
  public CapabilitiesBuilder() {
    this(false);
  }
  public CapabilitiesBuilder(Boolean validationEnabled) {
    this(new Capabilities(), validationEnabled);
  }
  public CapabilitiesBuilder(CapabilitiesFluent<?> fluent) {
    this(fluent, false);
  }
  public CapabilitiesBuilder(CapabilitiesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Capabilities(), validationEnabled);
  }
  public CapabilitiesBuilder(CapabilitiesFluent<?> fluent,Capabilities instance) {
    this(fluent, instance, false);
  }
  public CapabilitiesBuilder(CapabilitiesFluent<?> fluent,Capabilities instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Capabilities());

    if (instance != null) {
      fluent.withAdd(instance.getAdd());
      fluent.withDrop(instance.getDrop());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CapabilitiesBuilder(Capabilities instance) {
    this(instance,false);
  }
  public CapabilitiesBuilder(Capabilities instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Capabilities());

    if (instance != null) {
      this.withAdd(instance.getAdd());
      this.withDrop(instance.getDrop());
    }
    this.validationEnabled = validationEnabled; 
  }
  CapabilitiesFluent<?> fluent;
  Boolean validationEnabled;
  public Capabilities build() {
    Capabilities buildable = new Capabilities();
    buildable.setAdd(fluent.getAdd());
    buildable.setDrop(fluent.getDrop());
    return buildable;
  }
  
}