package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.containers.startupprobe;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GrpcBuilder extends GrpcFluent<GrpcBuilder> implements VisitableBuilder<Grpc,GrpcBuilder>{
  public GrpcBuilder() {
    this(false);
  }
  public GrpcBuilder(Boolean validationEnabled) {
    this(new Grpc(), validationEnabled);
  }
  public GrpcBuilder(GrpcFluent<?> fluent) {
    this(fluent, false);
  }
  public GrpcBuilder(GrpcFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Grpc(), validationEnabled);
  }
  public GrpcBuilder(GrpcFluent<?> fluent,Grpc instance) {
    this(fluent, instance, false);
  }
  public GrpcBuilder(GrpcFluent<?> fluent,Grpc instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Grpc());

    if (instance != null) {
      fluent.withPort(instance.getPort());
      fluent.withService(instance.getService());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GrpcBuilder(Grpc instance) {
    this(instance,false);
  }
  public GrpcBuilder(Grpc instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Grpc());

    if (instance != null) {
      this.withPort(instance.getPort());
      this.withService(instance.getService());
    }
    this.validationEnabled = validationEnabled; 
  }
  GrpcFluent<?> fluent;
  Boolean validationEnabled;
  public Grpc build() {
    Grpc buildable = new Grpc();
    buildable.setPort(fluent.getPort());
    buildable.setService(fluent.getService());
    return buildable;
  }
  
}