package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.dnsconfig;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OptionsBuilder extends OptionsFluent<OptionsBuilder> implements VisitableBuilder<Options,OptionsBuilder>{
  public OptionsBuilder() {
    this(false);
  }
  public OptionsBuilder(Boolean validationEnabled) {
    this(new Options(), validationEnabled);
  }
  public OptionsBuilder(OptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public OptionsBuilder(OptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Options(), validationEnabled);
  }
  public OptionsBuilder(OptionsFluent<?> fluent,Options instance) {
    this(fluent, instance, false);
  }
  public OptionsBuilder(OptionsFluent<?> fluent,Options instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Options());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OptionsBuilder(Options instance) {
    this(instance,false);
  }
  public OptionsBuilder(Options instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Options());

    if (instance != null) {
      this.withName(instance.getName());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  OptionsFluent<?> fluent;
  Boolean validationEnabled;
  public Options build() {
    Options buildable = new Options();
    buildable.setName(fluent.getName());
    buildable.setValue(fluent.getValue());
    return buildable;
  }
  
}