package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.ephemeralcontainers.env.valuefrom;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapKeyRefBuilder extends ConfigMapKeyRefFluent<ConfigMapKeyRefBuilder> implements VisitableBuilder<ConfigMapKeyRef,ConfigMapKeyRefBuilder>{
  public ConfigMapKeyRefBuilder() {
    this(false);
  }
  public ConfigMapKeyRefBuilder(Boolean validationEnabled) {
    this(new ConfigMapKeyRef(), validationEnabled);
  }
  public ConfigMapKeyRefBuilder(ConfigMapKeyRefFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapKeyRefBuilder(ConfigMapKeyRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMapKeyRef(), validationEnabled);
  }
  public ConfigMapKeyRefBuilder(ConfigMapKeyRefFluent<?> fluent,ConfigMapKeyRef instance) {
    this(fluent, instance, false);
  }
  public ConfigMapKeyRefBuilder(ConfigMapKeyRefFluent<?> fluent,ConfigMapKeyRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConfigMapKeyRef());

    if (instance != null) {
      fluent.withKey(instance.getKey());
      fluent.withName(instance.getName());
      fluent.withOptional(instance.getOptional());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapKeyRefBuilder(ConfigMapKeyRef instance) {
    this(instance,false);
  }
  public ConfigMapKeyRefBuilder(ConfigMapKeyRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConfigMapKeyRef());

    if (instance != null) {
      this.withKey(instance.getKey());
      this.withName(instance.getName());
      this.withOptional(instance.getOptional());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigMapKeyRefFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMapKeyRef build() {
    ConfigMapKeyRef buildable = new ConfigMapKeyRef();
    buildable.setKey(fluent.getKey());
    buildable.setName(fluent.getName());
    buildable.setOptional(fluent.getOptional());
    return buildable;
  }
  
}