package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.ephemeralcontainers.lifecycle;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PreStopBuilder extends PreStopFluent<PreStopBuilder> implements VisitableBuilder<PreStop,PreStopBuilder>{
  public PreStopBuilder() {
    this(false);
  }
  public PreStopBuilder(Boolean validationEnabled) {
    this(new PreStop(), validationEnabled);
  }
  public PreStopBuilder(PreStopFluent<?> fluent) {
    this(fluent, false);
  }
  public PreStopBuilder(PreStopFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PreStop(), validationEnabled);
  }
  public PreStopBuilder(PreStopFluent<?> fluent,PreStop instance) {
    this(fluent, instance, false);
  }
  public PreStopBuilder(PreStopFluent<?> fluent,PreStop instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PreStop());

    if (instance != null) {
      fluent.withExec(instance.getExec());
      fluent.withHttpGet(instance.getHttpGet());
      fluent.withTcpSocket(instance.getTcpSocket());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PreStopBuilder(PreStop instance) {
    this(instance,false);
  }
  public PreStopBuilder(PreStop instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PreStop());

    if (instance != null) {
      this.withExec(instance.getExec());
      this.withHttpGet(instance.getHttpGet());
      this.withTcpSocket(instance.getTcpSocket());
    }
    this.validationEnabled = validationEnabled; 
  }
  PreStopFluent<?> fluent;
  Boolean validationEnabled;
  public PreStop build() {
    PreStop buildable = new PreStop();
    buildable.setExec(fluent.buildExec());
    buildable.setHttpGet(fluent.buildHttpGet());
    buildable.setTcpSocket(fluent.buildTcpSocket());
    return buildable;
  }
  
}