package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.initcontainers;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LifecycleBuilder extends LifecycleFluent<LifecycleBuilder> implements VisitableBuilder<Lifecycle,LifecycleBuilder>{
  public LifecycleBuilder() {
    this(false);
  }
  public LifecycleBuilder(Boolean validationEnabled) {
    this(new Lifecycle(), validationEnabled);
  }
  public LifecycleBuilder(LifecycleFluent<?> fluent) {
    this(fluent, false);
  }
  public LifecycleBuilder(LifecycleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Lifecycle(), validationEnabled);
  }
  public LifecycleBuilder(LifecycleFluent<?> fluent,Lifecycle instance) {
    this(fluent, instance, false);
  }
  public LifecycleBuilder(LifecycleFluent<?> fluent,Lifecycle instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Lifecycle());

    if (instance != null) {
      fluent.withPostStart(instance.getPostStart());
      fluent.withPreStop(instance.getPreStop());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LifecycleBuilder(Lifecycle instance) {
    this(instance,false);
  }
  public LifecycleBuilder(Lifecycle instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Lifecycle());

    if (instance != null) {
      this.withPostStart(instance.getPostStart());
      this.withPreStop(instance.getPreStop());
    }
    this.validationEnabled = validationEnabled; 
  }
  LifecycleFluent<?> fluent;
  Boolean validationEnabled;
  public Lifecycle build() {
    Lifecycle buildable = new Lifecycle();
    buildable.setPostStart(fluent.buildPostStart());
    buildable.setPreStop(fluent.buildPreStop());
    return buildable;
  }
  
}