package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.initcontainers;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PortsBuilder extends PortsFluent<PortsBuilder> implements VisitableBuilder<Ports,PortsBuilder>{
  public PortsBuilder() {
    this(false);
  }
  public PortsBuilder(Boolean validationEnabled) {
    this(new Ports(), validationEnabled);
  }
  public PortsBuilder(PortsFluent<?> fluent) {
    this(fluent, false);
  }
  public PortsBuilder(PortsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Ports(), validationEnabled);
  }
  public PortsBuilder(PortsFluent<?> fluent,Ports instance) {
    this(fluent, instance, false);
  }
  public PortsBuilder(PortsFluent<?> fluent,Ports instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Ports());

    if (instance != null) {
      fluent.withContainerPort(instance.getContainerPort());
      fluent.withHostIP(instance.getHostIP());
      fluent.withHostPort(instance.getHostPort());
      fluent.withName(instance.getName());
      fluent.withProtocol(instance.getProtocol());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PortsBuilder(Ports instance) {
    this(instance,false);
  }
  public PortsBuilder(Ports instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Ports());

    if (instance != null) {
      this.withContainerPort(instance.getContainerPort());
      this.withHostIP(instance.getHostIP());
      this.withHostPort(instance.getHostPort());
      this.withName(instance.getName());
      this.withProtocol(instance.getProtocol());
    }
    this.validationEnabled = validationEnabled; 
  }
  PortsFluent<?> fluent;
  Boolean validationEnabled;
  public Ports build() {
    Ports buildable = new Ports();
    buildable.setContainerPort(fluent.getContainerPort());
    buildable.setHostIP(fluent.getHostIP());
    buildable.setHostPort(fluent.getHostPort());
    buildable.setName(fluent.getName());
    buildable.setProtocol(fluent.getProtocol());
    return buildable;
  }
  
}