package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.initcontainers;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReadinessProbeBuilder extends ReadinessProbeFluent<ReadinessProbeBuilder> implements VisitableBuilder<ReadinessProbe,ReadinessProbeBuilder>{
  public ReadinessProbeBuilder() {
    this(false);
  }
  public ReadinessProbeBuilder(Boolean validationEnabled) {
    this(new ReadinessProbe(), validationEnabled);
  }
  public ReadinessProbeBuilder(ReadinessProbeFluent<?> fluent) {
    this(fluent, false);
  }
  public ReadinessProbeBuilder(ReadinessProbeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReadinessProbe(), validationEnabled);
  }
  public ReadinessProbeBuilder(ReadinessProbeFluent<?> fluent,ReadinessProbe instance) {
    this(fluent, instance, false);
  }
  public ReadinessProbeBuilder(ReadinessProbeFluent<?> fluent,ReadinessProbe instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ReadinessProbe());

    if (instance != null) {
      fluent.withExec(instance.getExec());
      fluent.withFailureThreshold(instance.getFailureThreshold());
      fluent.withGrpc(instance.getGrpc());
      fluent.withHttpGet(instance.getHttpGet());
      fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      fluent.withPeriodSeconds(instance.getPeriodSeconds());
      fluent.withSuccessThreshold(instance.getSuccessThreshold());
      fluent.withTcpSocket(instance.getTcpSocket());
      fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReadinessProbeBuilder(ReadinessProbe instance) {
    this(instance,false);
  }
  public ReadinessProbeBuilder(ReadinessProbe instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ReadinessProbe());

    if (instance != null) {
      this.withExec(instance.getExec());
      this.withFailureThreshold(instance.getFailureThreshold());
      this.withGrpc(instance.getGrpc());
      this.withHttpGet(instance.getHttpGet());
      this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      this.withPeriodSeconds(instance.getPeriodSeconds());
      this.withSuccessThreshold(instance.getSuccessThreshold());
      this.withTcpSocket(instance.getTcpSocket());
      this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReadinessProbeFluent<?> fluent;
  Boolean validationEnabled;
  public ReadinessProbe build() {
    ReadinessProbe buildable = new ReadinessProbe();
    buildable.setExec(fluent.buildExec());
    buildable.setFailureThreshold(fluent.getFailureThreshold());
    buildable.setGrpc(fluent.buildGrpc());
    buildable.setHttpGet(fluent.buildHttpGet());
    buildable.setInitialDelaySeconds(fluent.getInitialDelaySeconds());
    buildable.setPeriodSeconds(fluent.getPeriodSeconds());
    buildable.setSuccessThreshold(fluent.getSuccessThreshold());
    buildable.setTcpSocket(fluent.buildTcpSocket());
    buildable.setTerminationGracePeriodSeconds(fluent.getTerminationGracePeriodSeconds());
    buildable.setTimeoutSeconds(fluent.getTimeoutSeconds());
    return buildable;
  }
  
}