package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.initcontainers.envfrom;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapRefBuilder extends ConfigMapRefFluent<ConfigMapRefBuilder> implements VisitableBuilder<ConfigMapRef,ConfigMapRefBuilder>{
  public ConfigMapRefBuilder() {
    this(false);
  }
  public ConfigMapRefBuilder(Boolean validationEnabled) {
    this(new ConfigMapRef(), validationEnabled);
  }
  public ConfigMapRefBuilder(ConfigMapRefFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapRefBuilder(ConfigMapRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMapRef(), validationEnabled);
  }
  public ConfigMapRefBuilder(ConfigMapRefFluent<?> fluent,ConfigMapRef instance) {
    this(fluent, instance, false);
  }
  public ConfigMapRefBuilder(ConfigMapRefFluent<?> fluent,ConfigMapRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConfigMapRef());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withOptional(instance.getOptional());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapRefBuilder(ConfigMapRef instance) {
    this(instance,false);
  }
  public ConfigMapRefBuilder(ConfigMapRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConfigMapRef());

    if (instance != null) {
      this.withName(instance.getName());
      this.withOptional(instance.getOptional());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigMapRefFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMapRef build() {
    ConfigMapRef buildable = new ConfigMapRef();
    buildable.setName(fluent.getName());
    buildable.setOptional(fluent.getOptional());
    return buildable;
  }
  
}