package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.initcontainers.envfrom;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretRefBuilder extends SecretRefFluent<SecretRefBuilder> implements VisitableBuilder<SecretRef,SecretRefBuilder>{
  public SecretRefBuilder() {
    this(false);
  }
  public SecretRefBuilder(Boolean validationEnabled) {
    this(new SecretRef(), validationEnabled);
  }
  public SecretRefBuilder(SecretRefFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretRefBuilder(SecretRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretRef(), validationEnabled);
  }
  public SecretRefBuilder(SecretRefFluent<?> fluent,SecretRef instance) {
    this(fluent, instance, false);
  }
  public SecretRefBuilder(SecretRefFluent<?> fluent,SecretRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SecretRef());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withOptional(instance.getOptional());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretRefBuilder(SecretRef instance) {
    this(instance,false);
  }
  public SecretRefBuilder(SecretRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SecretRef());

    if (instance != null) {
      this.withName(instance.getName());
      this.withOptional(instance.getOptional());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretRefFluent<?> fluent;
  Boolean validationEnabled;
  public SecretRef build() {
    SecretRef buildable = new SecretRef();
    buildable.setName(fluent.getName());
    buildable.setOptional(fluent.getOptional());
    return buildable;
  }
  
}