package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.initcontainers.lifecycle;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PostStartBuilder extends PostStartFluent<PostStartBuilder> implements VisitableBuilder<PostStart,PostStartBuilder>{
  public PostStartBuilder() {
    this(false);
  }
  public PostStartBuilder(Boolean validationEnabled) {
    this(new PostStart(), validationEnabled);
  }
  public PostStartBuilder(PostStartFluent<?> fluent) {
    this(fluent, false);
  }
  public PostStartBuilder(PostStartFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PostStart(), validationEnabled);
  }
  public PostStartBuilder(PostStartFluent<?> fluent,PostStart instance) {
    this(fluent, instance, false);
  }
  public PostStartBuilder(PostStartFluent<?> fluent,PostStart instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PostStart());

    if (instance != null) {
      fluent.withExec(instance.getExec());
      fluent.withHttpGet(instance.getHttpGet());
      fluent.withTcpSocket(instance.getTcpSocket());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PostStartBuilder(PostStart instance) {
    this(instance,false);
  }
  public PostStartBuilder(PostStart instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PostStart());

    if (instance != null) {
      this.withExec(instance.getExec());
      this.withHttpGet(instance.getHttpGet());
      this.withTcpSocket(instance.getTcpSocket());
    }
    this.validationEnabled = validationEnabled; 
  }
  PostStartFluent<?> fluent;
  Boolean validationEnabled;
  public PostStart build() {
    PostStart buildable = new PostStart();
    buildable.setExec(fluent.buildExec());
    buildable.setHttpGet(fluent.buildHttpGet());
    buildable.setTcpSocket(fluent.buildTcpSocket());
    return buildable;
  }
  
}