package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.initcontainers.lifecycle.poststart;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HttpGetBuilder extends HttpGetFluent<HttpGetBuilder> implements VisitableBuilder<HttpGet,HttpGetBuilder>{
  public HttpGetBuilder() {
    this(false);
  }
  public HttpGetBuilder(Boolean validationEnabled) {
    this(new HttpGet(), validationEnabled);
  }
  public HttpGetBuilder(HttpGetFluent<?> fluent) {
    this(fluent, false);
  }
  public HttpGetBuilder(HttpGetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HttpGet(), validationEnabled);
  }
  public HttpGetBuilder(HttpGetFluent<?> fluent,HttpGet instance) {
    this(fluent, instance, false);
  }
  public HttpGetBuilder(HttpGetFluent<?> fluent,HttpGet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HttpGet());

    if (instance != null) {
      fluent.withHost(instance.getHost());
      fluent.withHttpHeaders(instance.getHttpHeaders());
      fluent.withPath(instance.getPath());
      fluent.withPort(instance.getPort());
      fluent.withScheme(instance.getScheme());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HttpGetBuilder(HttpGet instance) {
    this(instance,false);
  }
  public HttpGetBuilder(HttpGet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HttpGet());

    if (instance != null) {
      this.withHost(instance.getHost());
      this.withHttpHeaders(instance.getHttpHeaders());
      this.withPath(instance.getPath());
      this.withPort(instance.getPort());
      this.withScheme(instance.getScheme());
    }
    this.validationEnabled = validationEnabled; 
  }
  HttpGetFluent<?> fluent;
  Boolean validationEnabled;
  public HttpGet build() {
    HttpGet buildable = new HttpGet();
    buildable.setHost(fluent.getHost());
    buildable.setHttpHeaders(fluent.buildHttpHeaders());
    buildable.setPath(fluent.getPath());
    buildable.setPort(fluent.getPort());
    buildable.setScheme(fluent.getScheme());
    return buildable;
  }
  
}