package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.initcontainers.lifecycle.poststart;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TcpSocketBuilder extends TcpSocketFluent<TcpSocketBuilder> implements VisitableBuilder<TcpSocket,TcpSocketBuilder>{
  public TcpSocketBuilder() {
    this(false);
  }
  public TcpSocketBuilder(Boolean validationEnabled) {
    this(new TcpSocket(), validationEnabled);
  }
  public TcpSocketBuilder(TcpSocketFluent<?> fluent) {
    this(fluent, false);
  }
  public TcpSocketBuilder(TcpSocketFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TcpSocket(), validationEnabled);
  }
  public TcpSocketBuilder(TcpSocketFluent<?> fluent,TcpSocket instance) {
    this(fluent, instance, false);
  }
  public TcpSocketBuilder(TcpSocketFluent<?> fluent,TcpSocket instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TcpSocket());

    if (instance != null) {
      fluent.withHost(instance.getHost());
      fluent.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TcpSocketBuilder(TcpSocket instance) {
    this(instance,false);
  }
  public TcpSocketBuilder(TcpSocket instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TcpSocket());

    if (instance != null) {
      this.withHost(instance.getHost());
      this.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  TcpSocketFluent<?> fluent;
  Boolean validationEnabled;
  public TcpSocket build() {
    TcpSocket buildable = new TcpSocket();
    buildable.setHost(fluent.getHost());
    buildable.setPort(fluent.getPort());
    return buildable;
  }
  
}