package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.initcontainers.securitycontext;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SeLinuxOptionsBuilder extends SeLinuxOptionsFluent<SeLinuxOptionsBuilder> implements VisitableBuilder<SeLinuxOptions,SeLinuxOptionsBuilder>{
  public SeLinuxOptionsBuilder() {
    this(false);
  }
  public SeLinuxOptionsBuilder(Boolean validationEnabled) {
    this(new SeLinuxOptions(), validationEnabled);
  }
  public SeLinuxOptionsBuilder(SeLinuxOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public SeLinuxOptionsBuilder(SeLinuxOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SeLinuxOptions(), validationEnabled);
  }
  public SeLinuxOptionsBuilder(SeLinuxOptionsFluent<?> fluent,SeLinuxOptions instance) {
    this(fluent, instance, false);
  }
  public SeLinuxOptionsBuilder(SeLinuxOptionsFluent<?> fluent,SeLinuxOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SeLinuxOptions());

    if (instance != null) {
      fluent.withLevel(instance.getLevel());
      fluent.withRole(instance.getRole());
      fluent.withType(instance.getType());
      fluent.withUser(instance.getUser());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SeLinuxOptionsBuilder(SeLinuxOptions instance) {
    this(instance,false);
  }
  public SeLinuxOptionsBuilder(SeLinuxOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SeLinuxOptions());

    if (instance != null) {
      this.withLevel(instance.getLevel());
      this.withRole(instance.getRole());
      this.withType(instance.getType());
      this.withUser(instance.getUser());
    }
    this.validationEnabled = validationEnabled; 
  }
  SeLinuxOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public SeLinuxOptions build() {
    SeLinuxOptions buildable = new SeLinuxOptions();
    buildable.setLevel(fluent.getLevel());
    buildable.setRole(fluent.getRole());
    buildable.setType(fluent.getType());
    buildable.setUser(fluent.getUser());
    return buildable;
  }
  
}