package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.initcontainers.securitycontext;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WindowsOptionsBuilder extends WindowsOptionsFluent<WindowsOptionsBuilder> implements VisitableBuilder<WindowsOptions,WindowsOptionsBuilder>{
  public WindowsOptionsBuilder() {
    this(false);
  }
  public WindowsOptionsBuilder(Boolean validationEnabled) {
    this(new WindowsOptions(), validationEnabled);
  }
  public WindowsOptionsBuilder(WindowsOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public WindowsOptionsBuilder(WindowsOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WindowsOptions(), validationEnabled);
  }
  public WindowsOptionsBuilder(WindowsOptionsFluent<?> fluent,WindowsOptions instance) {
    this(fluent, instance, false);
  }
  public WindowsOptionsBuilder(WindowsOptionsFluent<?> fluent,WindowsOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WindowsOptions());

    if (instance != null) {
      fluent.withGmsaCredentialSpec(instance.getGmsaCredentialSpec());
      fluent.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName());
      fluent.withHostProcess(instance.getHostProcess());
      fluent.withRunAsUserName(instance.getRunAsUserName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WindowsOptionsBuilder(WindowsOptions instance) {
    this(instance,false);
  }
  public WindowsOptionsBuilder(WindowsOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WindowsOptions());

    if (instance != null) {
      this.withGmsaCredentialSpec(instance.getGmsaCredentialSpec());
      this.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName());
      this.withHostProcess(instance.getHostProcess());
      this.withRunAsUserName(instance.getRunAsUserName());
    }
    this.validationEnabled = validationEnabled; 
  }
  WindowsOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public WindowsOptions build() {
    WindowsOptions buildable = new WindowsOptions();
    buildable.setGmsaCredentialSpec(fluent.getGmsaCredentialSpec());
    buildable.setGmsaCredentialSpecName(fluent.getGmsaCredentialSpecName());
    buildable.setHostProcess(fluent.getHostProcess());
    buildable.setRunAsUserName(fluent.getRunAsUserName());
    return buildable;
  }
  
}