package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SeccompProfileBuilder extends SeccompProfileFluent<SeccompProfileBuilder> implements VisitableBuilder<SeccompProfile,SeccompProfileBuilder>{
  public SeccompProfileBuilder() {
    this(false);
  }
  public SeccompProfileBuilder(Boolean validationEnabled) {
    this(new SeccompProfile(), validationEnabled);
  }
  public SeccompProfileBuilder(SeccompProfileFluent<?> fluent) {
    this(fluent, false);
  }
  public SeccompProfileBuilder(SeccompProfileFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SeccompProfile(), validationEnabled);
  }
  public SeccompProfileBuilder(SeccompProfileFluent<?> fluent,SeccompProfile instance) {
    this(fluent, instance, false);
  }
  public SeccompProfileBuilder(SeccompProfileFluent<?> fluent,SeccompProfile instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SeccompProfile());

    if (instance != null) {
      fluent.withLocalhostProfile(instance.getLocalhostProfile());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SeccompProfileBuilder(SeccompProfile instance) {
    this(instance,false);
  }
  public SeccompProfileBuilder(SeccompProfile instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SeccompProfile());

    if (instance != null) {
      this.withLocalhostProfile(instance.getLocalhostProfile());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  SeccompProfileFluent<?> fluent;
  Boolean validationEnabled;
  public SeccompProfile build() {
    SeccompProfile buildable = new SeccompProfile();
    buildable.setLocalhostProfile(fluent.getLocalhostProfile());
    buildable.setType(fluent.getType());
    return buildable;
  }
  
}