package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.securitycontext;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SysctlsBuilder extends SysctlsFluent<SysctlsBuilder> implements VisitableBuilder<Sysctls,SysctlsBuilder>{
  public SysctlsBuilder() {
    this(false);
  }
  public SysctlsBuilder(Boolean validationEnabled) {
    this(new Sysctls(), validationEnabled);
  }
  public SysctlsBuilder(SysctlsFluent<?> fluent) {
    this(fluent, false);
  }
  public SysctlsBuilder(SysctlsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Sysctls(), validationEnabled);
  }
  public SysctlsBuilder(SysctlsFluent<?> fluent,Sysctls instance) {
    this(fluent, instance, false);
  }
  public SysctlsBuilder(SysctlsFluent<?> fluent,Sysctls instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Sysctls());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SysctlsBuilder(Sysctls instance) {
    this(instance,false);
  }
  public SysctlsBuilder(Sysctls instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Sysctls());

    if (instance != null) {
      this.withName(instance.getName());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  SysctlsFluent<?> fluent;
  Boolean validationEnabled;
  public Sysctls build() {
    Sysctls buildable = new Sysctls();
    buildable.setName(fluent.getName());
    buildable.setValue(fluent.getValue());
    return buildable;
  }
  
}