package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AwsElasticBlockStoreBuilder extends AwsElasticBlockStoreFluent<AwsElasticBlockStoreBuilder> implements VisitableBuilder<AwsElasticBlockStore,AwsElasticBlockStoreBuilder>{
  public AwsElasticBlockStoreBuilder() {
    this(false);
  }
  public AwsElasticBlockStoreBuilder(Boolean validationEnabled) {
    this(new AwsElasticBlockStore(), validationEnabled);
  }
  public AwsElasticBlockStoreBuilder(AwsElasticBlockStoreFluent<?> fluent) {
    this(fluent, false);
  }
  public AwsElasticBlockStoreBuilder(AwsElasticBlockStoreFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AwsElasticBlockStore(), validationEnabled);
  }
  public AwsElasticBlockStoreBuilder(AwsElasticBlockStoreFluent<?> fluent,AwsElasticBlockStore instance) {
    this(fluent, instance, false);
  }
  public AwsElasticBlockStoreBuilder(AwsElasticBlockStoreFluent<?> fluent,AwsElasticBlockStore instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AwsElasticBlockStore());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withPartition(instance.getPartition());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withVolumeID(instance.getVolumeID());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AwsElasticBlockStoreBuilder(AwsElasticBlockStore instance) {
    this(instance,false);
  }
  public AwsElasticBlockStoreBuilder(AwsElasticBlockStore instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AwsElasticBlockStore());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withPartition(instance.getPartition());
      this.withReadOnly(instance.getReadOnly());
      this.withVolumeID(instance.getVolumeID());
    }
    this.validationEnabled = validationEnabled; 
  }
  AwsElasticBlockStoreFluent<?> fluent;
  Boolean validationEnabled;
  public AwsElasticBlockStore build() {
    AwsElasticBlockStore buildable = new AwsElasticBlockStore();
    buildable.setFsType(fluent.getFsType());
    buildable.setPartition(fluent.getPartition());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setVolumeID(fluent.getVolumeID());
    return buildable;
  }
  
}