package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzureDiskBuilder extends AzureDiskFluent<AzureDiskBuilder> implements VisitableBuilder<AzureDisk,AzureDiskBuilder>{
  public AzureDiskBuilder() {
    this(false);
  }
  public AzureDiskBuilder(Boolean validationEnabled) {
    this(new AzureDisk(), validationEnabled);
  }
  public AzureDiskBuilder(AzureDiskFluent<?> fluent) {
    this(fluent, false);
  }
  public AzureDiskBuilder(AzureDiskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AzureDisk(), validationEnabled);
  }
  public AzureDiskBuilder(AzureDiskFluent<?> fluent,AzureDisk instance) {
    this(fluent, instance, false);
  }
  public AzureDiskBuilder(AzureDiskFluent<?> fluent,AzureDisk instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AzureDisk());

    if (instance != null) {
      fluent.withCachingMode(instance.getCachingMode());
      fluent.withDiskName(instance.getDiskName());
      fluent.withDiskURI(instance.getDiskURI());
      fluent.withFsType(instance.getFsType());
      fluent.withKind(instance.getKind());
      fluent.withReadOnly(instance.getReadOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AzureDiskBuilder(AzureDisk instance) {
    this(instance,false);
  }
  public AzureDiskBuilder(AzureDisk instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AzureDisk());

    if (instance != null) {
      this.withCachingMode(instance.getCachingMode());
      this.withDiskName(instance.getDiskName());
      this.withDiskURI(instance.getDiskURI());
      this.withFsType(instance.getFsType());
      this.withKind(instance.getKind());
      this.withReadOnly(instance.getReadOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  AzureDiskFluent<?> fluent;
  Boolean validationEnabled;
  public AzureDisk build() {
    AzureDisk buildable = new AzureDisk();
    buildable.setCachingMode(fluent.getCachingMode());
    buildable.setDiskName(fluent.getDiskName());
    buildable.setDiskURI(fluent.getDiskURI());
    buildable.setFsType(fluent.getFsType());
    buildable.setKind(fluent.getKind());
    buildable.setReadOnly(fluent.getReadOnly());
    return buildable;
  }
  
}