package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzureFileBuilder extends AzureFileFluent<AzureFileBuilder> implements VisitableBuilder<AzureFile,AzureFileBuilder>{
  public AzureFileBuilder() {
    this(false);
  }
  public AzureFileBuilder(Boolean validationEnabled) {
    this(new AzureFile(), validationEnabled);
  }
  public AzureFileBuilder(AzureFileFluent<?> fluent) {
    this(fluent, false);
  }
  public AzureFileBuilder(AzureFileFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AzureFile(), validationEnabled);
  }
  public AzureFileBuilder(AzureFileFluent<?> fluent,AzureFile instance) {
    this(fluent, instance, false);
  }
  public AzureFileBuilder(AzureFileFluent<?> fluent,AzureFile instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AzureFile());

    if (instance != null) {
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretName(instance.getSecretName());
      fluent.withShareName(instance.getShareName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AzureFileBuilder(AzureFile instance) {
    this(instance,false);
  }
  public AzureFileBuilder(AzureFile instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AzureFile());

    if (instance != null) {
      this.withReadOnly(instance.getReadOnly());
      this.withSecretName(instance.getSecretName());
      this.withShareName(instance.getShareName());
    }
    this.validationEnabled = validationEnabled; 
  }
  AzureFileFluent<?> fluent;
  Boolean validationEnabled;
  public AzureFile build() {
    AzureFile buildable = new AzureFile();
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setSecretName(fluent.getSecretName());
    buildable.setShareName(fluent.getShareName());
    return buildable;
  }
  
}