package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CephfsBuilder extends CephfsFluent<CephfsBuilder> implements VisitableBuilder<Cephfs,CephfsBuilder>{
  public CephfsBuilder() {
    this(false);
  }
  public CephfsBuilder(Boolean validationEnabled) {
    this(new Cephfs(), validationEnabled);
  }
  public CephfsBuilder(CephfsFluent<?> fluent) {
    this(fluent, false);
  }
  public CephfsBuilder(CephfsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Cephfs(), validationEnabled);
  }
  public CephfsBuilder(CephfsFluent<?> fluent,Cephfs instance) {
    this(fluent, instance, false);
  }
  public CephfsBuilder(CephfsFluent<?> fluent,Cephfs instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Cephfs());

    if (instance != null) {
      fluent.withMonitors(instance.getMonitors());
      fluent.withPath(instance.getPath());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretFile(instance.getSecretFile());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withUser(instance.getUser());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CephfsBuilder(Cephfs instance) {
    this(instance,false);
  }
  public CephfsBuilder(Cephfs instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Cephfs());

    if (instance != null) {
      this.withMonitors(instance.getMonitors());
      this.withPath(instance.getPath());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretFile(instance.getSecretFile());
      this.withSecretRef(instance.getSecretRef());
      this.withUser(instance.getUser());
    }
    this.validationEnabled = validationEnabled; 
  }
  CephfsFluent<?> fluent;
  Boolean validationEnabled;
  public Cephfs build() {
    Cephfs buildable = new Cephfs();
    buildable.setMonitors(fluent.getMonitors());
    buildable.setPath(fluent.getPath());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setSecretFile(fluent.getSecretFile());
    buildable.setSecretRef(fluent.buildSecretRef());
    buildable.setUser(fluent.getUser());
    return buildable;
  }
  
}