package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CinderBuilder extends CinderFluent<CinderBuilder> implements VisitableBuilder<Cinder,CinderBuilder>{
  public CinderBuilder() {
    this(false);
  }
  public CinderBuilder(Boolean validationEnabled) {
    this(new Cinder(), validationEnabled);
  }
  public CinderBuilder(CinderFluent<?> fluent) {
    this(fluent, false);
  }
  public CinderBuilder(CinderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Cinder(), validationEnabled);
  }
  public CinderBuilder(CinderFluent<?> fluent,Cinder instance) {
    this(fluent, instance, false);
  }
  public CinderBuilder(CinderFluent<?> fluent,Cinder instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Cinder());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withVolumeID(instance.getVolumeID());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CinderBuilder(Cinder instance) {
    this(instance,false);
  }
  public CinderBuilder(Cinder instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Cinder());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withVolumeID(instance.getVolumeID());
    }
    this.validationEnabled = validationEnabled; 
  }
  CinderFluent<?> fluent;
  Boolean validationEnabled;
  public Cinder build() {
    Cinder buildable = new Cinder();
    buildable.setFsType(fluent.getFsType());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setSecretRef(fluent.buildSecretRef());
    buildable.setVolumeID(fluent.getVolumeID());
    return buildable;
  }
  
}