package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CsiBuilder extends CsiFluent<CsiBuilder> implements VisitableBuilder<Csi,CsiBuilder>{
  public CsiBuilder() {
    this(false);
  }
  public CsiBuilder(Boolean validationEnabled) {
    this(new Csi(), validationEnabled);
  }
  public CsiBuilder(CsiFluent<?> fluent) {
    this(fluent, false);
  }
  public CsiBuilder(CsiFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Csi(), validationEnabled);
  }
  public CsiBuilder(CsiFluent<?> fluent,Csi instance) {
    this(fluent, instance, false);
  }
  public CsiBuilder(CsiFluent<?> fluent,Csi instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Csi());

    if (instance != null) {
      fluent.withDriver(instance.getDriver());
      fluent.withFsType(instance.getFsType());
      fluent.withNodePublishSecretRef(instance.getNodePublishSecretRef());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withVolumeAttributes(instance.getVolumeAttributes());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CsiBuilder(Csi instance) {
    this(instance,false);
  }
  public CsiBuilder(Csi instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Csi());

    if (instance != null) {
      this.withDriver(instance.getDriver());
      this.withFsType(instance.getFsType());
      this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
      this.withReadOnly(instance.getReadOnly());
      this.withVolumeAttributes(instance.getVolumeAttributes());
    }
    this.validationEnabled = validationEnabled; 
  }
  CsiFluent<?> fluent;
  Boolean validationEnabled;
  public Csi build() {
    Csi buildable = new Csi();
    buildable.setDriver(fluent.getDriver());
    buildable.setFsType(fluent.getFsType());
    buildable.setNodePublishSecretRef(fluent.buildNodePublishSecretRef());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setVolumeAttributes(fluent.getVolumeAttributes());
    return buildable;
  }
  
}