package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EmptyDirBuilder extends EmptyDirFluent<EmptyDirBuilder> implements VisitableBuilder<EmptyDir,EmptyDirBuilder>{
  public EmptyDirBuilder() {
    this(false);
  }
  public EmptyDirBuilder(Boolean validationEnabled) {
    this(new EmptyDir(), validationEnabled);
  }
  public EmptyDirBuilder(EmptyDirFluent<?> fluent) {
    this(fluent, false);
  }
  public EmptyDirBuilder(EmptyDirFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EmptyDir(), validationEnabled);
  }
  public EmptyDirBuilder(EmptyDirFluent<?> fluent,EmptyDir instance) {
    this(fluent, instance, false);
  }
  public EmptyDirBuilder(EmptyDirFluent<?> fluent,EmptyDir instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EmptyDir());

    if (instance != null) {
      fluent.withMedium(instance.getMedium());
      fluent.withSizeLimit(instance.getSizeLimit());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EmptyDirBuilder(EmptyDir instance) {
    this(instance,false);
  }
  public EmptyDirBuilder(EmptyDir instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EmptyDir());

    if (instance != null) {
      this.withMedium(instance.getMedium());
      this.withSizeLimit(instance.getSizeLimit());
    }
    this.validationEnabled = validationEnabled; 
  }
  EmptyDirFluent<?> fluent;
  Boolean validationEnabled;
  public EmptyDir build() {
    EmptyDir buildable = new EmptyDir();
    buildable.setMedium(fluent.getMedium());
    buildable.setSizeLimit(fluent.getSizeLimit());
    return buildable;
  }
  
}