package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EphemeralBuilder extends EphemeralFluent<EphemeralBuilder> implements VisitableBuilder<Ephemeral,EphemeralBuilder>{
  public EphemeralBuilder() {
    this(false);
  }
  public EphemeralBuilder(Boolean validationEnabled) {
    this(new Ephemeral(), validationEnabled);
  }
  public EphemeralBuilder(EphemeralFluent<?> fluent) {
    this(fluent, false);
  }
  public EphemeralBuilder(EphemeralFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Ephemeral(), validationEnabled);
  }
  public EphemeralBuilder(EphemeralFluent<?> fluent,Ephemeral instance) {
    this(fluent, instance, false);
  }
  public EphemeralBuilder(EphemeralFluent<?> fluent,Ephemeral instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Ephemeral());

    if (instance != null) {
      fluent.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EphemeralBuilder(Ephemeral instance) {
    this(instance,false);
  }
  public EphemeralBuilder(Ephemeral instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Ephemeral());

    if (instance != null) {
      this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  EphemeralFluent<?> fluent;
  Boolean validationEnabled;
  public Ephemeral build() {
    Ephemeral buildable = new Ephemeral();
    buildable.setVolumeClaimTemplate(fluent.buildVolumeClaimTemplate());
    return buildable;
  }
  
}